package scj.algorithm.twotrees.labeling.minmax.analysis;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

import java.util.Arrays;

public class FlatSearchAnalysisSizeCorrelations implements Search {

	private static final Logger LOGGER = LoggerFactory.getLogger(FlatSearchAnalysisSizeCorrelations.class);
	public static final int LEVELS = 20;

	protected Result result;

	private FlatLeftTreeDirectBuildMinPathLength R;
	private PIETreeMaxPathLength S;

	public long[] runTime = new long[LEVELS+1];
	private long currentTime;

	public FlatSearchAnalysisSizeCorrelations(FlatLeftTreeDirectBuildMinPathLength t1, PIETreeMaxPathLength t2, Result result) {
		this.R = t1;
		this.S = t2;
		this.result = result;
	}

	@Override
	public Result search() {
		for(int i=0;i<LEVELS+1;i++) {
			runTime[i] = 0;
		}
		currentTime = System.currentTimeMillis();
		this.search(0, 0, 0);
		return result;
	}
	
	public String toString() {
		return R + "\n" + S;
	}
	
	/*
	 * Search.
	 */	
	protected long search(final int r, final int s, final int level) {

		long start = System.currentTimeMillis();
		long childs = 0;

		lookForOutput(r, s);

		// Traversal
		for (int c_r : R.getChildrenOf(r)) {
			IntList result = S.findRanges(R.getNameOf(c_r), s);
			IntListIterator resultItr = result.iterator();
			while(resultItr.hasNext()) {
                final int c_s = resultItr.nextInt();
                childs+= search(c_r, c_s, level+1);
			}
		}

		long time = System.currentTimeMillis() - childs -start;

		LOGGER.info("pos\t{}\t{}\t{}\t{}\t{}",level, r, s, time, time+childs);
		return time;
	}

	private void lookForOutput(int r, int s) {
		IntCollection content_r = R.getIdsByPosition(r);
		IntIterator it_r = content_r.iterator();
		
		if(it_r.hasNext()) {
			
			// Build set of results on right side
			IntCollection result_s = S.getIdsByPosition(s, S.getRangeEnd(s) + 1);
			
			while(it_r.hasNext()) {
				int nextInt = it_r.nextInt();
				IntIterator it_s = result_s.iterator();
				while(it_s.hasNext()) {
					result.add(nextInt, it_s.nextInt());				
				}
			}	
		}
			
	}






}
