package scj.algorithm.twotrees.labeling.minmax;

import it.unimi.dsi.fastutil.ints.*;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class MinMaxSearchListBasedRecursion implements Search {

//	private static final Logger LOGGER = LoggerFactory.getLogger(EncodedSearch.class);

	protected Result result;

	private FlatLeftTreeDirectBuildMinPathLength R;
	private PIETreeMaxPathLength S;

	public MinMaxSearchListBasedRecursion(FlatLeftTreeDirectBuildMinPathLength t1, PIETreeMaxPathLength t2, Result result) {
		this.R = t1;
		this.S = t2;
		this.result = result;
	}

	@Override
	public Result search() {
        final IntArrayList integers = new IntArrayList();
        integers.add(0);
        this.search(0, integers);
		return result;
	}
	
	public String toString() {
		return R + "\n" + S;
	}
	
	/*
	 * Search.
	 */
    protected void search(int r, IntList s) {

        if(s.size() == 0) {
            return;
        }

        lookForOutput(r, s);

        // Traversal
        for (int c_r : R.getChildrenOf(r)) {

            int min_path = R.getMinPathLengthOf(c_r);
            final IntList allRanges = S.findAllRanges(R.getNameOf(c_r), s);
            IntList result = new IntArrayList(allRanges);
            IntListIterator resultItr = result.iterator();
            while(resultItr.hasNext()) {
                final int c_s = resultItr.nextInt();
                if(min_path > S.getMaxPathLengthOf(c_s)) {
                    resultItr.remove();
                }
            }
            search(c_r, result);
        }
    }

    private void lookForOutput(int r, IntList s) {
        IntCollection content_r = R.getIdsByPosition(r);

        if (content_r.isEmpty()) {
            return;
        }

        IntIterator it_preorder_s = s.iterator();
        while(it_preorder_s.hasNext()) {
            int preorder_s = it_preorder_s.nextInt();

            IntList content_s = S.getIdsByPosition(preorder_s, S.getRangeEnd(preorder_s) + 1);
            IntIterator it_content_r = content_r.iterator();
            while(it_content_r.hasNext()) {
                int tupleId_r = it_content_r.nextInt();
                IntIterator it_content_s = content_s.iterator();
                while(it_content_s.hasNext()) {
                    result.add(tupleId_r, it_content_s.nextInt());
                }
            }
        }

    }

}
