package scj.algorithm.twotrees.labeling.minmax;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class MinMaxSearch implements Search {

//	private static final Logger LOGGER = LoggerFactory.getLogger(EncodedSearch.class);
	
	protected Result result;

	private FlatLeftTreeDirectBuildMinPathLength R;
	private PIETreeMaxPathLength S;

	public MinMaxSearch(FlatLeftTreeDirectBuildMinPathLength t1, PIETreeMaxPathLength t2, Result result) {
		this.R = t1;
		this.S = t2;
		this.result = result;
	}

	@Override
	public Result search() {
		this.search(0, 0);
		return result;
	}
	
	public String toString() {
		return R + "\n" + S;
	}
	
	/*
	 * Search.
	 */	
	protected void search(int r, int s) {		

		lookForOutput(r, s);

		// Traversal
		for (int c_r : R.getChildrenOf(r)) {
            int min_path = R.getMinPathLengthOf(c_r);
			IntList result = S.findRanges(R.getNameOf(c_r), s);
			IntListIterator resultItr = result.iterator();
			while(resultItr.hasNext()) {
                final int c_s = resultItr.nextInt();
                if(min_path <= S.getMaxPathLengthOf(c_s)) {
                    search(c_r, c_s);
                }
			}
		}
	}

	private void lookForOutput(int r, int s) {
		IntCollection content_r = R.getIdsByPosition(r);
		IntIterator it_r = content_r.iterator();
		
		if(it_r.hasNext()) {
			
			// Build set of results on right side
			IntCollection result_s = S.getIdsByPosition(s, S.getRangeEnd(s) + 1);
			
			while(it_r.hasNext()) {
				int nextInt = it_r.nextInt();
				IntIterator it_s = result_s.iterator();
				while(it_s.hasNext()) {
					result.add(nextInt, it_s.nextInt());				
				}
			}	
		}
			
	}






}
