package scj.algorithm.twotrees.labeling.minmax;

import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.Search;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.flat.FlatSearch;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

import java.util.Set;

public class FlatBothMinMaxListBasedRecursion extends FlatBoth {
    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());

        final FlatLeftTreeDirectBuildMinPathLength t1 = rc.measure(new Executable<FlatLeftTreeDirectBuildMinPathLength>() {
            public FlatLeftTreeDirectBuildMinPathLength execute() {
                return (FlatLeftTreeDirectBuildMinPathLength) new FlatTreeCreatorLeftSideDirectMinPathLength().getInnerFlatTree(n_a, sortOrder);
            }
        }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>() {
            public FlatLeftTree execute() {
                t1.complete();
                return t1;
            }
        }, "build prefix tree 1 -- completion");
        LOGGER.debug("Prefix tree of data set 1: {}", t1);

        PIETreeMaxPathLength t2=
                rc.measure(new Executable<PIETreeMaxPathLength>() {
                    public PIETreeMaxPathLength execute() {
                        return (PIETreeMaxPathLength) new FlatTreeCreatorRightSideDirectMaxPathLength().getOuterFlatTree(n_b, sortOrder);
                    }
                }, "build prefix tree 2");
        LOGGER.debug("Prefix tree of data set 2: {}", t2);

        LOGGER.info("{}", rc);

        //Do scj on it
        if(Executor.MODE == Executor.EXECUTION_MODE.Time) {
            Search search = new MinMaxSearchListBasedRecursion(t1, t2, result);
            search.search();
        }
    }
}
