package scj.algorithm.twotrees.labeling.listrecursion;

import it.unimi.dsi.fastutil.ints.*;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class FlatSearchListBasedRecursion implements Search {

	protected Result result;

	private FlatLeftTree R;
	private PIETree S;

	public FlatSearchListBasedRecursion(FlatLeftTree t1, PIETree t2, Result result) {
		this.R = t1;
		this.S = t2;
		this.result = result;
	}

	@Override
	public Result search() {
        final IntArrayList integers = new IntArrayList();
        integers.add(0);
        this.search(0, integers);
        System.out.println(S.recursionTime + " - " + S.scopeTime);
        return result;
	}
	
	public String toString() {
		return R + "\n" + S;
	}
	
	/*
	 * Search.
	 */	
	protected void search(int r, IntList s) {

        if(s.size() == 0) {
            return;
        }

		lookForOutput(r, s);

		// Traversal
		for (int c_r : R.getChildrenOf(r)) {
            search(c_r, S.findAllRanges(R.getNameOf(c_r), s));
		}
	}

	private void lookForOutput(int r, IntList s) {
		IntCollection content_r = R.getIdsByPosition(r);

        if (content_r.isEmpty()) {
            return;
        }

        IntIterator it_preorder_s = s.iterator();
        while(it_preorder_s.hasNext()) {
            int preorder_s = it_preorder_s.nextInt();

            IntList content_s = S.getIdsByPosition(preorder_s, S.getRangeEnd(preorder_s) + 1);
            IntIterator it_content_r = content_r.iterator();
            while(it_content_r.hasNext()) {
                int tupleId_r = it_content_r.nextInt();
                IntIterator it_content_s = content_s.iterator();
                while(it_content_s.hasNext()) {
                    result.add(tupleId_r, it_content_s.nextInt());
                }
            }
        }

    }
}
