package scj.algorithm.twotrees.labeling.flat.semi;

import scj.algorithm.tree.Node;
import scj.algorithm.tree.leftside.semi.SemiFlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

import java.util.Set;

public class SemiFlatNone extends DAAlgorithm {

    @Override
	public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
		RuntimeCalculator rc = new RuntimeCalculator(this.getClass());

        final SemiFlatTreeCreator flatTreeCreator = new SemiFlatTreeCreator();

        final Node innerPrefixTree =
                rc.measure(new Executable<Node>() {
                    public Node execute() {
                        return flatTreeCreator.getPrefixTree(n_a, sortOrder);
                    }
                }, "build prefix tree 1 - step: build prefix tree");
        SemiFlatLeftTree t1 =
                rc.measure(new Executable<SemiFlatLeftTree>() {
                    public SemiFlatLeftTree execute() {
                        return flatTreeCreator.getInnerFlatTree(innerPrefixTree);
                    }
                }, "build prefix tree 1 - step: build flat");
        LOGGER.debug("Prefix tree of data set 1: {}", t1);

        final Node outerPrefixTree =
                rc.measure(new Executable<Node>() {
                    public Node execute() {
                        return flatTreeCreator.getPrefixTree(n_b, sortOrder);
                    }
                }, "build prefix tree 2 - step: build prefix tree");
        PIETree t2 =
                rc.measure(new Executable<PIETree>() {
                    public PIETree execute() {
                        return flatTreeCreator.getOuterFlatTree(outerPrefixTree);
                    }
                }, "build prefix tree 2 - step: build flat");
		LOGGER.debug("Prefix tree of data set 2: {}", t2);
		
		LOGGER.info("{}", rc);

        //Do scj on it
        if(Executor.MODE == Executor.EXECUTION_MODE.Time) {
            Search search = new SemiFlatSearch(t1, t2, result);
            search.search();
        }
	}

}
