package scj.algorithm.twotrees.labeling.flat;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.tree.rightside.PIETree;
import scj.input.DataTuple;
import scj.algorithm.order.SortOrder;
import scj.runtime.RuntimeCalculator;

import java.util.*;

public class FlatTreeCreatorRightSideDirect {

	private static final Logger LOGGER = LoggerFactory.getLogger(FlatTreeCreatorRightSideDirect.class);

	public PIETree getOuterFlatTree(Set<DataTuple> data, SortOrder sortOrder) {
		
		// The setrecursion themself are already sorted. We have to order them in a way that there will be no confusion -> usual int ordering.
		RuntimeCalculator rc = new RuntimeCalculator();
		rc.start("sorting");
		List<DataTuple> listData = new ArrayList<DataTuple>(data);
		Comparator<? super DataTuple> bvc = new TupleComparator();
		Collections.sort(listData, bvc );
		rc.stop("sorting");

        PIETree tree = getPieTree(listData);

		rc.start("build tree");
		List<Integer> activePrefixPos = new ArrayList<Integer>();
		List<Integer> activePrefix = new ArrayList<Integer>();
		int nodeId = 0;
		tree.addNameToPreorder(-1,0);
		for (DataTuple tuple : listData) {
			//System.out.println("Tuple: "+tuple);
			for(int pos=0;pos<tuple.getSet().length;pos++) {
				int element = tuple.getSet()[pos];

				if(activePrefix.size() > pos) {
					/*
					* aP: a b c*
					* ?     z
					*
					* */
					if(activePrefix.get(pos)==element) {
						// z=b
						// Same entry as in row before.
						// Do nothing.
						// ?   a b
					} else {
						// z!=b
						// Remove b c* from aP
						while(activePrefix.size() > pos) {
							int last = activePrefixPos.remove(activePrefixPos.size() -1);
							activePrefix.remove(activePrefix.size()-1);
							tree.addRangeEnd(last, nodeId);
						}
						// ?   a
					}
				} else {
					/*
					* aP: a b c
					* ?         z
					*
					* */
					// Do nothing. Everything matches.
					// ? a b c z
 				}

				//Prefix matches.
				if(!activePrefix.contains(element) && activePrefix.size() ==pos) {
					nodeId++;
					activePrefixPos.add(nodeId);
					activePrefix.add(element);
					tree.addNameToPreorder(element,nodeId);
				}
				if(pos == tuple.getSet().length -1) {
					tree.addPreorderToContent(nodeId,tuple.getId());
				}
			}
		}
		while(activePrefixPos.size()>0) {
			int last = activePrefixPos.remove(activePrefixPos.size() -1);
			tree.addRangeEnd(last, nodeId);
		}
		tree.addRangeEnd(0,nodeId);
		rc.stop("build tree");

		LOGGER.info("{}", rc);
		return tree;
	}

    public PIETree getPieTree(List<DataTuple> listData) {
        PIETree tree1 = new PIETree();
        tree1.init(listData.size());
        return tree1;
    }

    public class TupleComparator implements Comparator<DataTuple> {
		@Override
		public int compare(DataTuple o1, DataTuple o2) {
			return new IntArrayList(o1.getSet()).compareTo(new IntArrayList(o2.getSet()));
		}
	}
}
