package scj.algorithm.twotrees.labeling.flat;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.input.DataTuple;
import scj.runtime.RuntimeCalculator;

import java.util.*;

public class FlatTreeCreatorLeftSideDirect {

	private static final Logger LOGGER = LoggerFactory.getLogger(FlatTreeCreatorLeftSideDirect.class);

	public FlatLeftTreeDirectBuild getInnerFlatTree(Set<DataTuple> data, SortOrder sortOrder) {
		
		// The sets themself are already sorted. We have to order them in a way that there will be no confusion -> usual int ordering.
		RuntimeCalculator rc = new RuntimeCalculator();
		rc.start("sorting");
		List<DataTuple> listData = new ArrayList<DataTuple>(data);
		Comparator<? super DataTuple> bvc = new TupleComparator();
		Collections.sort(listData, bvc );
		rc.stop("sorting");


        FlatLeftTreeDirectBuild tree = getFlatLeftTree(listData);
        rc.start("build tree");

        List<Integer> activePrefixPos = new ArrayList<Integer>();
        List<Integer> activePrefix = new ArrayList<Integer>();
        int nodeId = 0;
        for (DataTuple tuple : listData) {
            //System.out.println("Tuple: "+tuple);
            for(int pos=0;pos<tuple.getSet().length;pos++) {
                int element = tuple.getSet()[pos];

                if(activePrefix.size() > pos) {
                    if(activePrefix.get(pos)!=element) {
                        // z!=b
                        // Remove b c* from aP
                        while(activePrefix.size() > pos) {
                            activePrefixPos.remove(activePrefixPos.size() -1);
                            activePrefix.remove(activePrefix.size()-1);
                        }
                        // ?   a
                    }
                }

                //Prefix matches.
                if(!activePrefix.contains(element) && activePrefix.size() ==pos) {
                    int parent = pos==0? 0 : activePrefixPos.get(activePrefixPos.size()-1);
                    tree.addNode(parent, element);
                    nodeId++;
                    activePrefixPos.add(nodeId);
                    activePrefix.add(element);

                }
                if(pos == tuple.getSet().length -1) {
                    tree.addTupleToNode(nodeId, tuple.getId());
                }
            }
        }
 		rc.stop("build tree");
		LOGGER.info("{}", rc);
		return tree;
	}

    public FlatLeftTreeDirectBuild getFlatLeftTree(List<DataTuple> listData) {
        return new FlatLeftTreeDirectBuild(listData.size());
    }

    public class TupleComparator implements Comparator<DataTuple> {
		@Override
		public int compare(DataTuple o1, DataTuple o2) {
			return new IntArrayList(o1.getSet()).compareTo(new IntArrayList(o2.getSet()));
		}
	}
}
