package scj.algorithm.twotrees.labeling.flat;

import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.*;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeFromPrefixTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.input.DataTuple;

import java.util.Set;

public class FlatTreeCreator {

	public PIETree getOuterFlatTree(Node prefixTree) {
		return new PIETree(prefixTree);
	}

	public FlatLeftTree getInnerFlatTree(Node prefixTree) {
		return new FlatLeftTreeFromPrefixTree(prefixTree);
	}

	public Node getPrefixTree(Set<DataTuple> data, SortOrder sortOrder) {
		TreeNode rootNode = getTreeNode(TreeNode.DEFAULT_VALUE);
		for (DataTuple date : data) {

			//System.out.println("Tuple p: "+date);
			// Go to the matching position
			Node traverser = rootNode;
			Node tmp;
			for (int contentElement : date.getSet()) {
				tmp = traverser.getChild(contentElement);
				if (tmp == null) {
					tmp = getTreeNode(contentElement);
					traverser.addChild(tmp);
				}
				traverser = tmp;
			}
			traverser.addContent(date.getId());

		}

		if (rootNode instanceof TTTreeNode) {
			((TTTreeNode) rootNode).postCreate();
		}

		return rootNode;
	}

	protected TreeNode getTreeNode(int contentElement) {
		return new TreeNodeWithIntervalAnnotation(contentElement);
	}
}
