package scj.algorithm.twotrees.labeling.flat;

import java.util.Set;

import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;
import scj.algorithm.tree.Node;

public class FlatNone extends DAAlgorithm {

    @Override
	public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
		RuntimeCalculator rc = new RuntimeCalculator(this.getClass());

        final FlatTreeCreator flatTreeCreator = new FlatTreeCreator();

        final Node innerPrefixTree =
                rc.measure(new Executable<Node>() {
                    public Node execute() {
                        return flatTreeCreator.getPrefixTree(n_a, sortOrder);
                    }
                }, "build prefix tree 1 - step: build prefix tree");
        FlatLeftTree t1 =
                rc.measure(new Executable<FlatLeftTree>() {
                    public FlatLeftTree execute() {
                        return flatTreeCreator.getInnerFlatTree(innerPrefixTree);
                    }
                }, "build prefix tree 1 - step: build flat");
        LOGGER.debug("Prefix tree of data set 1: {}", t1);

        final Node outerPrefixTree =
                rc.measure(new Executable<Node>() {
                    public Node execute() {
                        return flatTreeCreator.getPrefixTree(n_b, sortOrder);
                    }
                }, "build prefix tree 2 - step: build prefix tree");
        PIETree t2 =
                rc.measure(new Executable<PIETree>() {
                    public PIETree execute() {
                        return flatTreeCreator.getOuterFlatTree(outerPrefixTree);
                    }
                }, "build prefix tree 2 - step: build flat");
		LOGGER.debug("Prefix tree of data set 2: {}", t2);
		
		LOGGER.info("{}", rc);

        //Do scj on it
        if(Executor.MODE == Executor.EXECUTION_MODE.Time) {
            Search search = new FlatSearch(t1, t2, result);
            search.search();
        }
	}

}
