package scj.algorithm.twotrees.labeling.flat;

import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

import java.util.Set;

public class FlatBothForSpaceMeasuring extends DAAlgorithm {
    @Override
	public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
		RuntimeCalculator rc = new RuntimeCalculator(this.getClass());

        final FlatLeftTreeDirectBuild t1 =
                rc.measure(new Executable<FlatLeftTreeDirectBuild>() {
                    public FlatLeftTreeDirectBuild execute() {
                        return new FlatTreeCreatorLeftSideDirect().getInnerFlatTree(n_a, sortOrder);
                    }
                }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>() {
            public FlatLeftTree execute() {
                t1.transformChildrenData();
                return t1;
            }
        }, "build prefix tree 1 -- transforming");
        rc.measure(new Executable<FlatLeftTree>() {
            public FlatLeftTree execute() {
                t1.unsetChildrenVerticalData();
                return t1;
            }
        }, "build prefix tree 1 -- unset data");
        LOGGER.debug("Prefix tree of data set 1: {}", t1);

        PIETree t2=
                rc.measure(new Executable<PIETree>() {
                    public PIETree execute() {
                        return new FlatTreeCreatorRightSideDirect().getOuterFlatTree(n_b, sortOrder);
                    }
                }, "build prefix tree 2");
        LOGGER.debug("Prefix tree of data set 2: {}", t2);
		
		LOGGER.info("{}", rc);

        //Do scj on it
        if(Executor.MODE == Executor.EXECUTION_MODE.Time) {
            Search search = new FlatSearch(t1, t2, result);
            search.search();
        }
	}
}
