package scj.algorithm.twotrees.labeling;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.input.DataTuple;
import scj.result.Result;

import java.util.Set;

public abstract class DAAlgorithm extends ConfigurableRawDataAlgorithm {
	protected SortOrder sortOrder;
	protected Logger LOGGER;

	public DAAlgorithm() {
		sortOrder = new InverseFrequencyOrder();
		LOGGER = LoggerFactory.getLogger(toString());
	}

	public void setSortOrder(SortOrder order) {
		sortOrder = order;
		LOGGER = LoggerFactory.getLogger(toString());
	}

	public DAAlgorithm withSortOrder(SortOrder order) {
		this.setSortOrder(order);
		return this;
	}

    @Override
    public String toString() {
        return getClass().getName()+"{" +
                "sortOrder=" + sortOrder.toString() +
                '}';
    }

    @Override
	public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
		sortOrder.initialize(set2);
		for(DataTuple r : set1) {
			sortOrder.sort(r.getSet());
		}

		for(DataTuple r : set2) {
			sortOrder.sort(r.getSet());
		}
	}
}
