package scj.algorithm.tree.rightside;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

@SuppressWarnings("serial")
public class PIETreeMaxPathLength extends PIETree {

    private IntArrayList maxPathLengths;

    public void init(int tupleCount) {
        super.init(tupleCount);
        this.maxPathLengths = new IntArrayList(tupleCount);
    }

    @Override
    public void addRangeEnd(int nodeId, int rangeEndId) {
        super.addRangeEnd(nodeId,rangeEndId);
        // Alle Kinder sind bereits vollständig berechnet

        if(nodeId == rangeEndId) {
            // Blatt.
            setMaxPathLength(nodeId, 0);
            return;
        }

        // Maximum aller direkten Kinder
        // NodeId in [nodeid,rangeEndId]
        // und Immer alle Knoten aussparen, die in intervall von Kind liegen
        int n = nodeId+1;
        int max = 0;
        while(n <= rangeEndId) {
            int max_path = this.getMaxPathLengthOf(n);
            if(max < max_path) {
                max = max_path;
            }
            n = this.getRangeEnd(n)+1;
        }
        // +1
        this.setMaxPathLength(nodeId,max+1);
    }

    protected void setMaxPathLength(int nodeId, int pathLength) {
        this.maxPathLengths.ensureCapacity(nodeId);
        for(int i=this.maxPathLengths.size();i<=nodeId;i++) {
            this.maxPathLengths.add(i,0);
        }
        this.maxPathLengths.set(nodeId, pathLength);
    }


    public int getMaxPathLengthOf(int nodeId) {
        return this.maxPathLengths.getInt(nodeId);
    }
}
