package scj.algorithm.tree.leftside.semi;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNodeWithIntervalAnnotation;

import java.util.Collection;


@SuppressWarnings("serial")
public class SemiFlatLeftTreeFromPrefixTree extends SemiFlatLeftTree {

	public SemiFlatLeftTreeFromPrefixTree(Node prefixTree) {
		this.size = 0;
		readFromTree((TreeNodeWithIntervalAnnotation) prefixTree);
	}

	private void readFromTree(TreeNodeWithIntervalAnnotation prefixTree) {
		decorateWithIntervals(prefixTree, 0);
		
		this.size = prefixTree.getI2();
		this.tupleIdPositions = new IntArrayList(this.size);
		this.tupleIds = new IntArrayList();

        this.childrenVertical = new ObjectArrayList<>(this.size);

		this.nodeNames = new IntArrayList(this.size);
		
		pickIntervals(prefixTree);
		
	}

	private int decorateWithIntervals(TreeNodeWithIntervalAnnotation prefixTree, int i) {
		prefixTree.setI1(i);
		for(Node child: prefixTree.getChildren()) {
			i = this.decorateWithIntervals((TreeNodeWithIntervalAnnotation) child, i+1);
		}
		//TODO we do not need I2 in this tree!
		prefixTree.setI2(i);
		return i;
	}

	private void pickIntervals(TreeNodeWithIntervalAnnotation prefixTree) {
		this.nodeNames.add(prefixTree.getI1(), prefixTree.getName());

		// Pick contents
		this.tupleIdPositions.add(prefixTree.getI1(), this.tupleIds.size());
		this.tupleIds.addAll(prefixTree.getTupleIds());

        Collection<Node> children = prefixTree.getChildren();
		if(children.isEmpty()) {
            this.childrenVertical.add(null);
        } else {
            IntArrayList tmp = new IntArrayList(children.size());
            for (Node child : children) {
                tmp.add(((TreeNodeWithIntervalAnnotation) child).getI1());
            }
            this.childrenVertical.add(tmp);
        }

		// Recurse preordered -> lists are sorted by nature.
		for (Node child : children) {
			this.pickIntervals((TreeNodeWithIntervalAnnotation) child);
		}

	}
}
