package scj.algorithm.tree.leftside.semi;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;


public class SemiFlatLeftTreeDirectBuild extends SemiFlatLeftTree {



    public SemiFlatLeftTreeDirectBuild(int tupleCount) {
		int estNodeCnt = tupleCount;
		this.size = 1;
		this.tupleIdPositions = new IntArrayList(estNodeCnt);
		this.tupleIds = new IntArrayList(tupleCount);
        this.childrenVertical = new ObjectArrayList<>(estNodeCnt);
		this.nodeNames = new IntArrayList(estNodeCnt);

		this.tupleIdPositions.add(0);
        this.childrenVertical.add(0, null);
		this.nodeNames.add(-1);
	}

	public int addNode(int position, int name) {
		// CAUTION: works only if insertion is in preorder!!!
		
		int newNodeId = this.size;

		//Insert new node.
		this.nodeNames.add(newNodeId, name);
		
		//Add children relation.
		this.addChildRelation(position, newNodeId);
		
		this.tupleIdPositions.add(newNodeId, this.tupleIds.size());
        this.childrenVertical.add(newNodeId, null);

		//Size grows.
		this.size++;
		
		return newNodeId;
	}
	
	/**
	 * Insert a child ID in the flattened child array.
	 */
	private void addChildRelation(int parentId, int childId) {
        IntArrayList vertical = this.childrenVertical.get(parentId);
        if(vertical == null) {
            vertical = new IntArrayList(2);
        }
        vertical.add(childId);
        this.childrenVertical.set(parentId, vertical);

    }

    public void complete() {
    }


    public void addTupleToNode(int node, int tupleId) {
        insertIntoSkipList(this.tupleIdPositions, this.tupleIds, node, tupleId);
    }

    protected void insertIntoSkipList(IntList positionList, IntList valueList, int position, int value) {
        if(position + 1 == positionList.size()) {
            //It's the last entry, just insert.
            valueList.add(value);
        } else {

            //Insert the value.
            int insertIndex = positionList.get(position + 1);
            valueList.add(insertIndex, value);

            //And shift the position indizes of all later entries.
            for(int i=position + 1;i < positionList.size(); i++) {
                positionList.set(i, positionList.get(i) + 1);
            }
        }
    }

}
