package scj.algorithm.tree.leftside;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;


public class FlatLeftTreeDirectBuildMinPathLength extends FlatLeftTreeDirectBuild {

    private IntList minPathLengths;

    public FlatLeftTreeDirectBuildMinPathLength(int tupleCount) {
        super(tupleCount);
    }

    public void complete() {
        super.complete();
        setPathLengths();
    }

    public void setPathLengths() {
        this.minPathLengths = new IntArrayList(this.size);
        for(int i=0;i<this.size;i++) {
            minPathLengths.add(i,0);
        }
        /*
        Traverse the tree.
         */
        findMinPathLengthOf(0);
    }

    private int findMinPathLengthOf(int x) {
        //  If leaf -> 0 or has tupleId.
        IntList c = this.getChildrenOf(x);
        IntListIterator it = c.iterator();
        if(getIdsByPosition(x).size()>0 || this.getChildrenOf(x).size() == 0) {

            while(it.hasNext()) {
                int child = it.nextInt();
                findMinPathLengthOf(child);
            }
            this.minPathLengths.set(x,0);
            return 0;
            } else {
            int min = this.size;
            while(it.hasNext()) {
                int child = it.nextInt();
                final int minPathLengthOf = findMinPathLengthOf(child);
                if(minPathLengthOf < min) {
                    min = minPathLengthOf;
                }
            }
            this.minPathLengths.set(x, min+1);
            return min+1;
        }
    }

    public int getMinPathLengthOf(int nodeId) {
        return this.minPathLengths.getInt(nodeId);
    }
}
