package scj.algorithm.tree.leftside;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;


public class FlatLeftTreeDirectBuild extends FlatLeftTree {


    protected ObjectList<IntArrayList> childrenVertical;

    public FlatLeftTreeDirectBuild(int tupleCount) {
		int estNodeCnt = tupleCount;
		this.size = 1;
		this.tupleIdPositions = new IntArrayList(estNodeCnt);
		this.tupleIds = new IntArrayList(tupleCount);
		this.childrenPositions = new IntArrayList(estNodeCnt);
        this.children = new IntArrayList(estNodeCnt);
        this.childrenVertical = new ObjectArrayList<>(estNodeCnt);
		this.nodeNames = new IntArrayList(estNodeCnt);

		this.tupleIdPositions.add(0);
        this.childrenVertical.add(0, null);
		this.nodeNames.add(-1);
	}

	public int addNode(int position, int name) {
		// CAUTION: works only if insertion is in preorder!!!
		
		int newNodeId = this.size;

		//Insert new node.
		this.nodeNames.add(newNodeId, name);
		
		//Add children relation.
		this.addChildRelation(position, newNodeId);
		
		this.tupleIdPositions.add(newNodeId, this.tupleIds.size());
        this.childrenVertical.add(newNodeId, null);

		//Size grows.
		this.size++;
		
		return newNodeId;
	}
	
	/**
	 * Insert a child ID in the flattened child array.
	 */
	private void addChildRelation(int parentId, int childId) {
        IntArrayList vertical = this.childrenVertical.get(parentId);
        if(vertical == null) {
            vertical = new IntArrayList(2);
        }
        vertical.add(childId);
        this.childrenVertical.set(parentId,vertical);

    }

    public void complete() {
        transformChildrenData();
        unsetChildrenVerticalData();
    }

    public void unsetChildrenVerticalData() {
        this.childrenVertical = null;
    }

    public void transformChildrenData() {
        int offset = 0;
        this.childrenPositions.ensureCapacity(this.size);
        for(int i=0;i<this.size;i++) {
            this.childrenPositions.add(offset);
            IntArrayList vertical = childrenVertical.get(i);
            if(vertical != null) {
                this.children.addAll(vertical);
                offset += vertical.size();
            }
        }
    }


    public void addTupleToNode(int node, int tupleId) {
        insertIntoSkipList(this.tupleIdPositions, this.tupleIds, node, tupleId);
    }

    protected void insertIntoSkipList(IntList positionList, IntList valueList, int position, int value) {
        if(position + 1 == positionList.size()) {
            //It's the last entry, just insert.
            valueList.add(value);
        } else {

            //Insert the value.
            int insertIndex = positionList.get(position + 1);
            valueList.add(insertIndex, value);

            //And shift the position indizes of all later entries.
            for(int i=position + 1;i < positionList.size(); i++) {
                positionList.set(i, positionList.get(i) + 1);
            }
        }
    }

}
