package scj.algorithm.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressWarnings("serial")
public class TTTreeNode extends TreeNode {

	protected List<Node> childrenlist;
	
	public TTTreeNode(int contentElement) {
		super(contentElement);
	}
	
	@Override
	public Collection<Node> getChildren() {
		return this.childrenlist;
	}
	
	public void postCreate() {
		this.childrenlist = new ArrayList<Node>(this.children.values());
		sortChildrenList();
		
		for(Node child : this.getChildren()) {
			((TTTreeNode) child).postCreate();
		}
	}

	protected void sortChildrenList() {
		//Don't order.
	}

}