package scj.algorithm.tree;

import java.io.Serializable;
import java.util.Collection;
import gnu.trove.list.linked.TIntLinkedList;

public interface LinkedNode extends Serializable, Comparable<LinkedNode>, Tree {
	public int getName();
	public TIntLinkedList getTupleIds();
	public Collection<LinkedNode> getChildren();
	
	public LinkedNode getChild(int contentElement);
	

	public void addContent(int i);
	public void addChild(LinkedNode node);
	public boolean equalsName(LinkedNode t2);
	public boolean containsTuples();
	public boolean greaterThanOrEqualsName(LinkedNode c_b);
}
