package scj.algorithm.pretti;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;

import java.util.Set;

import scj.input.DataTuple;

public class TupleIDList {
	
	private static final double ESTIMATED_SIZE_REDUCTION_AT_INTERSECTION = 0.5;
	
	public static TIntArrayList getCandicateListContainingAllEntries(Set<DataTuple> set2) {
		TIntArrayList cl = new TIntArrayList(set2.size());
		for(DataTuple tuple: set2) {
			cl.add(tuple.getId());
		}
		cl.sort();
		return cl;
	}
	
	public static TIntArrayList intersect(TIntArrayList tupleIDCandidates, TIntArrayList tIntArrayList) {
//		return tIntArrayList;
		if(tupleIDCandidates.size()==0) {
			return tupleIDCandidates;
		}
		if(tIntArrayList.size()==0) {
			return tIntArrayList;
		}
		int estimatedListSize = (int) (ESTIMATED_SIZE_REDUCTION_AT_INTERSECTION * Math.min(tupleIDCandidates.size(), tIntArrayList.size()));
		TIntArrayList newList = new TIntArrayList(estimatedListSize);
		
		TIntIterator iterA = tupleIDCandidates.iterator();
		TIntIterator iterB = tIntArrayList.iterator();
		int b = iterB.next();
		while(iterA.hasNext()) {
			int a = iterA.next();
			while(iterB.hasNext() && (a > b)) {
				b = iterB.next();
			}
			if(!iterB.hasNext() && (a > b)) {
				break;
			}
			if(a == b ) {
				newList.add(a);
			} 
		}
		
		return newList;
	}
}
