package scj.algorithm.pretti;

import java.util.Set;

import scj.input.DataTuple;
import scj.algorithm.tree.TreeNode;

public class PrettiPrefixTree extends PrettiPrefixTreeNode {

	private static final long serialVersionUID = 652459005036259723L;

	public PrettiPrefixTree(Set<DataTuple> set1) {
		super(TreeNode.DEFAULT_VALUE);
		this.createTree(set1);		
	}
	
	protected PrettiPrefixTreeNode createTree(Set<DataTuple> data) {
		PrettiPrefixTreeNode rootNode = this;
		for(DataTuple date: data) {
			//Go to the matching position
			PrettiPrefixTreeNode traverser = rootNode;
			PrettiPrefixTreeNode tmp;
			for(int contentElement: date.getSet()) {
				tmp = (PrettiPrefixTreeNode) traverser.getChild(contentElement);
				if(tmp != null) {
					traverser = tmp;
				} else {
					tmp = new PrettiPrefixTreeNode(contentElement);
					traverser.addChild(tmp);
					traverser = tmp;
				}
			}
			//And insert the node
			traverser.addContent(date.getId());
		}
		return rootNode;
	}
}
