package scj.algorithm.pretti;

import gnu.trove.list.array.TIntArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

import java.util.Map;
import java.util.Set;

import scj.input.DataTuple;

public class PrettiInvertedIndex {
	
	private static final TIntArrayList EMPTY_LIST = new TIntArrayList();
	protected Map<Integer, TIntArrayList> index;

	public PrettiInvertedIndex(Set<DataTuple> set2) {
		this.index = new Int2ObjectOpenHashMap<TIntArrayList>();
		this.fillIndex(set2);
	}

	protected void fillIndex(Set<DataTuple> set2) {
		for(DataTuple tuple: set2) {
			for(int name: tuple.getSet()) {
				if(!this.index.containsKey(name)) {
					this.index.put(name, new TIntArrayList());
				}
				this.index.get(name).add(tuple.getId());					
				
			}
			
		}	
		for(TIntArrayList tupleIdList: this.index.values()) {
			tupleIdList.sort();
		}
	}
	
	public int getSize() {
		return index.keySet().size();
	}

	public TIntArrayList get(int i) {
		if(this.index.containsKey(i)) {
			return this.index.get(i);					
		} 
		return EMPTY_LIST;
	}
	
	public String toString() {
		return "Inverted index: "+this.index.toString();
		
	}

}
