package scj.algorithm.parallel.rangetask;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.result.Result;

import java.util.ArrayList;

public class SearchRangeTaskWholeTree implements SearchRangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchRangeTaskWholeTree.class);

    private FlatRangeSearchParallelization search;
    private int r;
    private Result result;


    @Override
    public void set(L1RangeTaskSearch onePairSearch, int rangeStart) {
        this.search = onePairSearch;
        this.r = rangeStart;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {

        long tmpTime = System.currentTimeMillis();
        search(r);

        tmpTime = System.currentTimeMillis() - tmpTime;
        search.result.add(result);
        search.informFinished(this);
        LOGGER.info("{}\t{} ms",r,tmpTime);
    }

    private void search(int rangeStart) {
        final IntList childrenR = search.R.getChildrenOf(0);

        //LOGGER.info("Call on {} for {} steps, there are {} childs at all",rangeStart, L1RangeTaskSearch.getIdealRangeSize(), childrenR.size());
        for(int i=0;(i+rangeStart)<childrenR.size() && i<L1RangeTaskSearch.getRangeSize();i++) {
//            LOGGER.info("Worked on {}",i+rangeStart);
            int r = childrenR.getInt(i + rangeStart);
            final int nameOf = search.R.getNameOf(r);
            search(r, 0, nameOf);
        }

    }


    protected void search(int r, int s, int name) {
        IntList result = search.S.findRanges(name, s);
        IntListIterator resultItr = result.iterator();
        while (resultItr.hasNext()) {
            search(r, resultItr.nextInt());
        }

    }
    /*
     * search.
     */
    protected void search(int r, int s) {

        lookForOutput(r, s);

        // Traversal
        for (int c_r : search.R.getChildrenOf(r)) {
            IntList result = search.S.findRanges(search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    result.add(nextInt, it_s.nextInt());
                }
            }
        }

    }


}
