package scj.algorithm.parallel.rangetask;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.result.Result;

public class SearchRangeInitTask implements SearchRangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchRangeInitTask.class);
    public static final int RANGE_SIZE = 10;
    private Result result;

    @Override
    public String toString() {
        return "SearchInit{}";
    }

    protected FlatRangeSearchParallelization search;

    public SearchRangeInitTask(L1RangeTaskSearch l1RangeTaskSearch) {
        this.search = l1RangeTaskSearch;
        this.result = l1RangeTaskSearch.result.getSubresult();
    }

    @Override
    public void set(L1RangeTaskSearch onePairSearch, int rangeStart) {
        this.search = onePairSearch;
        this.result = onePairSearch.result.getSubresult();
    }


    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        search(0, 0);
        //LOGGER.info("Run ready on {},{}", r, s);
        search.result.add(result);
        search.informFinished(this);
    }

    /*
     * search.
     */
    protected void search(int r, int s) {

        lookForOutput(r, s);

        // Traversal
        final IntList childrenR = search.R.getChildrenOf(r);
        final int rangeSize = L1RangeTaskSearch.findAndSetRangeSize(childrenR.size());
        for(int i=0;i<childrenR.size();i+= rangeSize) {
            search.addNewSearch(i);
        }

    }

    protected void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    final int nextInt1 = it_s.nextInt();
                    //synchronized (result) {
					result.add(nextInt, nextInt1);
                    //}
                    //LOGGER.info("Output" + nextInt + "," + nextInt1);
                }
            }
        }

    }
}
