package scj.algorithm.parallel.rangetask;

import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.result.Result;


public class L1RangeTaskSearch extends FlatRangeSearchParallelization {

    private static final Logger LOGGER = LoggerFactory.getLogger(L1RangeTaskSearch.class);
    private static int rangeSize;


    public L1RangeTaskSearch(FlatLeftTree t1, PIETree t2, Result result, int threads) {
		super(t2, result, t1, threads);
	}

    public PoolSettings<? extends SearchTask> getSearchTaskPoolSettings() {
        return new PoolSettings<SearchRangeTask>(
            new PoolableObjectBase<SearchRangeTask>() {
                @Override
                public SearchRangeTask make() {
                    return new SearchRangeTaskWholeTree();
                }
                @Override
                public void activate(SearchRangeTask t) {
                }
            });
    }

    @Override
    public void addNewSearchInit() {
        try {
            SearchTask task = new SearchRangeInitTask(this);
            this.numberOfTasks.incrementAndGet();
            threadPool.execute(task);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static int findAndSetRangeSize(int nodeCount) {
        int estimatedBestExecutorCount = nThreads * 10;
        rangeSize = (nodeCount/estimatedBestExecutorCount);
        if(rangeSize<1) {
            rangeSize = 1;
        }

        return rangeSize;
    }

    public static int getRangeSize() {
        return rangeSize;
    }

    public void addNewSearch(int rangeStart) {
        try {
            SearchTask task = objectPool.getObj();
            ((SearchRangeTask) task).set(this, rangeStart);

            this.numberOfTasks.incrementAndGet();
            threadPool.execute(task);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
	}
}
