package scj.algorithm.parallel.rangetask;

import nf.fr.eraasoft.pool.PoolSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.LoggingQueue;
import scj.algorithm.parallel.ThreadPoolExecutorWithObjectPool;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FlatRangeSearchParallelization implements Search {
	private static final Logger LOGGER = LoggerFactory.getLogger(FlatRangeSearchParallelization.class);

	protected static int nThreads = 16;

	public Result result;
	public FlatLeftTree R;
	public PIETree S;

    protected nf.fr.eraasoft.pool.ObjectPool<? extends SearchTask> objectPool;
    private final PoolSettings<? extends SearchTask> poolSettings;

	public void setThreads(int nThreads) {
		this.nThreads = nThreads;
	}

	public ThreadPoolExecutorWithObjectPool threadPool;
	protected AtomicInteger numberOfTasks = new AtomicInteger(0);

	public FlatRangeSearchParallelization(PIETree t2, Result result, FlatLeftTree t1, int threads) {
		this.S = t2;
		this.result = result;
		this.R = t1;

        this.setThreads(nThreads);

        this.threadPool = getThreadPoolExecutor(); // 2 Param: Queue-Typ - PriorityQueue mglich

        poolSettings = getSearchTaskPoolSettings();
        poolSettings.min(0).max(-1).validateWhenReturn(false);
        objectPool = poolSettings.pool();
        this.threadPool.setObjectPool(objectPool);

    }

    public ThreadPoolExecutorWithObjectPool getThreadPoolExecutor() {
        return new ThreadPoolExecutorWithObjectPool(nThreads, nThreads,
                0L, TimeUnit.MILLISECONDS,
                new LoggingQueue<Runnable>(nThreads));
    }

    @Override
	public Result search() {
		addNewSearchInit();

 //		LOGGER.info("working");
		while(this.numberOfTasks.get() > 0) {
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		try {
			threadPool.shutdown();
			threadPool.awaitTermination(10, TimeUnit.DAYS);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

        LOGGER.info("Final pool status: {}",threadPool.toString());
        poolSettings.shutdown();

		return this.result;
	}

    protected abstract PoolSettings<? extends SearchTask> getSearchTaskPoolSettings();

    public abstract void addNewSearchInit();

    public abstract void addNewSearch(int rangeStart);

	public String toString() {
		return R + "\n" + S;
	}

    public void informFinished(SearchTask searchTaskOnePair) {
        this.numberOfTasks.decrementAndGet();
    }

}
