package scj.algorithm.parallel.nodetask.switching;

import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.result.Result;


public class SwitchBySizeSearch extends FlatSearchParallelization {

    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchBySizeSearch.class);


    public SwitchBySizeSearch(FlatLeftTree t1, PIETree t2, Result result, int threads) {
		super(t2, result, t1, threads);
	}

    public PoolSettings<? extends SearchTask> getSearchTaskPoolSettings() {
        return new PoolSettings<SearchTask>(
            new PoolableObjectBase<SearchTask>() {
                @Override
                public SearchTask make() {
                    return new SearchTaskSwitchBySize();
                }
                @Override
                public void activate(SearchTask t) {
                }
            });
    }

    @Override
    public void addNewSearch(int r, int s) {
        try {
             SearchTask task = objectPool.getObj();
             task.set(this, r, s);

             this.numberOfTasks.incrementAndGet();
             threadPool.execute(task);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
	}
}
