package scj.algorithm.parallel.nodetask.switching;

import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.parallel.nodetask.SearchTaskOneTask;
import scj.algorithm.parallel.nodetask.SearchTaskWholeTree;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.result.Result;


public class SwitchByLevelSearch extends FlatSearchParallelization {

    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchByLevelSearch.class);


    public SwitchByLevelSearch(FlatLeftTree t1, PIETree t2, Result result, int threads) {
		super(t2, result, t1, threads);
	}

    public PoolSettings<? extends SearchTask> getSearchTaskPoolSettings() {
        return new PoolSettings<SearchTask>(
            new PoolableObjectBase<SearchTask>() {
                @Override
                public SearchTask make() {
                    return new SearchTaskWholeTree();
                }
                @Override
                public void activate(SearchTask t) {
                    //LOGGER.info("Task started: {}",t.toString());
                }
            });
    }

    @Override
    public void addNewSearch(int r, int s) {
            try {
                SearchTask task;
                if(r == 0 && s == 0) {
                    task = new SearchTaskOneTask(this, r, s);
                } else {
                    task = objectPool.getObj();
                    task.set(this, r, s);
                }
                this.numberOfTasks.incrementAndGet();
                threadPool.execute(task);
            } catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
	}
}
