package scj.algorithm.parallel.nodetask.switching;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.nodetask.SearchTaskOneTask;

class SearchTaskSwitchBySize extends SearchTaskOneTask {
	private static final Logger LOGGER = LoggerFactory.getLogger(SearchTaskSwitchBySize.class);

    public SearchTaskSwitchBySize(FlatSearchParallelization flatSearchParallelized, int r, int s) {
        this.search = flatSearchParallelized;
        this.r = r;
        this.s = s;
    }

    public SearchTaskSwitchBySize() {}

    /*
     * search.
     */
    protected void search(int r, int s) {

        lookForOutput(r, s);

        // Traversal
        for (int c_r : search.R.getChildrenOf(r)) {
            IntList result = search.S.findRanges(search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                if(search.S.getRangeEnd(s)-s > (0.05 * search.S.getSize())) {
                    search(c_r,resultItr.nextInt());
                } else {
                    search.addNewSearch(c_r, resultItr.nextInt());
                }
            }
        }
    }
}
