package scj.algorithm.parallel.nodetask;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.result.Result;

public class SearchTaskWholeTree implements SearchTask {
	private static final Logger LOGGER = LoggerFactory.getLogger(SearchTaskWholeTree.class);
    private Result result;

    private FlatSearchParallelization search;
    private int r;
    private int s;

    public SearchTaskWholeTree(OneTaskSearch flatSearchParallelized, int r, int s) {
        this.search = flatSearchParallelized;
        this.r = r;
        this.s = s;
        this.result = flatSearchParallelized.result.getSubresult();
    }

    @Override
    public String toString() {
        return "SearchTaskWholeTree{" +
                "r=" + r +
                ", s=" + s +
                '}';
    }

    public SearchTaskWholeTree() {

    }


    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        this.search = onePairSearch;
        this.r = r;
        this.s = s;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public void run() {
        //LOGGER.info("Run on {},{}", r, s);
        search(r, s);
        search.result.add(result);
        search.informFinished(this);
    }

    /*
     * search.
     */
    protected void search(int r, int s) {

        lookForOutput(r, s);

        // Traversal
        for (int c_r : search.R.getChildrenOf(r)) {
            IntList result = search.S.findRanges(search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    final int nextInt1 = it_s.nextInt();
                    //synchronized (result) {
					result.add(nextInt, nextInt1);
                    //}
                    //LOGGER.info("Output" + nextInt + "," + nextInt1);
                }
            }
        }

    }


}
