package scj.algorithm.parallel.nodetask;

import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.result.Result;


public class OneTaskSearch extends FlatSearchParallelization {

    private static final Logger LOGGER = LoggerFactory.getLogger(OneTaskSearch.class);


    public OneTaskSearch(FlatLeftTree t1, PIETree t2, Result result, int threads) {
		super(t2, result, t1, threads);
	}

    public PoolSettings<? extends SearchTask> getSearchTaskPoolSettings() {
        return new PoolSettings<SearchTask>(
            new PoolableObjectBase<SearchTask>() {
                @Override
                public SearchTask make() {
                    return new SearchTaskOneTask();
                }
                @Override
                public void activate(SearchTask t) {
                }
            });
    }

    @Override
    public void addNewSearch(int r, int s) {
        try {
             SearchTask task = objectPool.getObj();
             task.set(this, r, s);

             threadPool.execute(task);
             this.numberOfTasks.incrementAndGet();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
	}
}
