package scj.algorithm.parallel.listtask;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.result.Result;

public class SearchListTaskWholeTree implements SearchListTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchListTaskWholeTree.class);

    private FlatListSearchParallelization search;
    private int r;
    private int s;
    private int name;
    private Result result;

    @Override
    public String toString() {
        return "SearchTaskWholeTree{" +
                "r=" + r +
                ", s=" + s +
                ", name=" + name +
                '}';
    }

    public SearchListTaskWholeTree() {

    }


    @Override
    public void set(FlatListSearchParallelization onePairSearch, int r, int name) {
        this.search = onePairSearch;
        this.r = r;
        this.s = s;
        this.name = name;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        //LOGGER.info("Run on {},{}", r, s);
        searchN(r, name);
        search.result.add(result);
        search.informFinished(this);
    }


    protected void searchN(int r, int name) {
        IntList result = search.S.findRanges(name, 0);
        IntListIterator resultItr = result.iterator();
        while (resultItr.hasNext()) {
            search(r, resultItr.nextInt());
        }

    }
    /*
     * search.
     */
    protected void search(int r, int s) {

        lookForOutput(r, s);

        // Traversal
        for (int c_r : search.R.getChildrenOf(r)) {
            IntList result = search.S.findRanges(search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    result.add(nextInt, it_s.nextInt());
                }
            }
        }

    }


}
