package scj.algorithm.parallel.listtask;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.result.Result;

public class SearchListTaskOneTask implements SearchListTask {
	private static final Logger LOGGER = LoggerFactory.getLogger(SearchListTaskOneTask.class);
    private Result result;

    @Override
    public String toString() {
        return "SearchTaskOneTask{" +
                "r=" + r +
                ", s=" + s +
                '}';
    }

    protected FlatListSearchParallelization search;
    protected int r;
    protected int s;

    public SearchListTaskOneTask(FlatListSearchParallelization flatSearchParallelized, int r, int s) {
        this.search = flatSearchParallelized;
        this.r = r;
        this.s = s;
        this.result = flatSearchParallelized.result.getSubresult();
    }

    public SearchListTaskOneTask() {

    }

    @Override
    public void set(FlatListSearchParallelization onePairSearch, int r, int name) {
        this.search = onePairSearch;
        this.r = r;
    }


    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
//        LOGGER.info("Run on {},{}", r, s);
        search(r, s);
        //LOGGER.info("Run ready on {},{}", r, s);
        search.result.add(result);
        search.informFinished(this);
    }

    /*
     * search.
     */
    protected void search(int r, int s) {

        lookForOutput(r, s);

        // Traversal
        for (int c_r : search.R.getChildrenOf(r)) {
            search.addNewSearch(c_r, s, search.R.getNameOf(c_r));
        }
    }

    protected void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    final int nextInt1 = it_s.nextInt();
                    //synchronized (result) {
					result.add(nextInt, nextInt1);
                    //}
                    //LOGGER.info("Output" + nextInt + "," + nextInt1);
                }
            }
        }

    }
}
