package scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntList;
import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.result.Result;


public class AdaptiveRangingSearch extends AdaptiveRangeSearchParallelization {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptiveRangingSearch.class);


    public AdaptiveRangingSearch(FlatLeftTree t1, PIETree t2, Result result, int threads) {
		super(t2, result, t1, threads);
	}

    public PoolSettings<? extends SearchTask> getSearchTaskPoolSettings() {
        return new PoolSettings<>(
            new PoolableObjectBase<PrioritizedRangeTask>() {
                @Override
                public PrioritizedRangeTask make() {
                    return new PrioritizedRangeTaskWholeTree();
                }
                @Override
                public void activate(PrioritizedRangeTask t) {
                }
            });
    }

    @Override
    public void addNewSearchInit() {
        try {
            SearchTask task = new PrioritizedInitTask(this);
            this.numberOfTasks.incrementAndGet();
            threadPool.execute(task);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void addNewSplitting(int nodeId, IntList matchingRangeStartsS) {
        try {
            SearchTask task = new PrioritizedSplittingTask(this,nodeId, matchingRangeStartsS );
            this.numberOfTasks.incrementAndGet();
            threadPool.execute(task);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    // Durchsuche alle Kinder von nodeId zwischen Indizes rangeStart und i-1 und joine diese mit allen geeigneten Kindknoten von Knoten aus rangeStartS.
    public void addNewSearch(int nodeId, int rangeStart, int rangeEnd, IntList rangeStartsS) {
        try {
            SearchTask task = objectPool.getObj();
            ((PrioritizedRangeTaskWholeTree) task).set(this, nodeId, rangeStart, rangeEnd, rangeStartsS);

            this.numberOfTasks.incrementAndGet();
            threadPool.execute(task);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}
