package scj.algorithm.parallel.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.result.Result;

public class SplittingTask implements RangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplittingTask.class);
    public static final int RANGE_SIZE = 10;
    private final Result result;
    private int nodeId;
    private IntList rangeStartsS;

    @Override
    public String toString() {
        return "SplittingTask{}";
    }

    protected AdaptiveRangingSearch search;

    public SplittingTask(AdaptiveRangingSearch adaptiveRangingSearch, int nodeId, IntList matchingRangeStartsS) {
        this.search = adaptiveRangingSearch;
        this.nodeId = nodeId;
        this.rangeStartsS = matchingRangeStartsS;
        this.result = adaptiveRangingSearch.result.getSubresult();
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();

        splitAndStartSearches(nodeId);
//        LOGGER.info("Split recursion performed on node {}", nodeId);

        long tmpTime = System.currentTimeMillis() - startTime;

//        LOGGER.info("Split search starting on node {}, {} partner ids", nodeId, rangeStartsS.size());
        search(nodeId,rangeStartsS);
        search.result.add(result);
        startTime = System.currentTimeMillis() - startTime;
        //LOGGER.info("Run ready on {},{}", r, s);
        search.informFinished(this);
        LOGGER.info("Splitting: node {}\t {} ms + {} ms", nodeId, startTime, tmpTime);
    }

    /*
     * search.
     */
    protected void search(int nodeId, IntList rangeStartsS) {
        IntListIterator resultItr = rangeStartsS.iterator();
        while (resultItr.hasNext()) {
            lookForOutput(nodeId, resultItr.nextInt());
        }
    }

    private void splitAndStartSearches(int nodeId) {
        final IntList childrenR = search.R.getChildrenOf(nodeId);
        final int idealRangeSize = getIdealRangeSize(search.getOverallItemCount());

        int rangeStart = 0;
        int rangeFreqSum = 0;


        LOGGER.info("{}: {} child nodes",nodeId, childrenR.size());

        for(int i=0;i<childrenR.size();i++) {
            int childNodeId = childrenR.getInt(i);
            final int childNodeName = search.R.getNameOf(childNodeId);
            int freq = search.getFrequencyMap().containsKey(childNodeName) ? search.getFrequencyMap().get(childNodeName) : 1;
            if(rangeFreqSum+freq < idealRangeSize) {
                rangeFreqSum+= freq;
                continue;
            } else {
                if (rangeStart == i) {
                    //LOGGER.info("Should try to split node {}->{} (name: {}), has size {} (> optimum of {})", nodeId, childNodeId, childNodeName, freq, idealRangeSize);
                    search.addNewSearch(nodeId, rangeStart, i, rangeStartsS);
                    rangeFreqSum = freq;
                    rangeStart = i + 1;
                } else {
                    // Durchsuche alle Kinder von nodeId zwischen Indizes rangeStart und i-1 und joine diese mit allen geeigneten Kindknoten von Knoten aus rangeStartS.
                    search.addNewSearch(nodeId, rangeStart, i - 1, rangeStartsS);
                    rangeFreqSum = freq;
                    rangeStart = i;
                }
            }
        }
        if(rangeStart != childrenR.size()) {
            search.addNewSearch(nodeId,rangeStart,childrenR.size()-1,rangeStartsS);
        }
    }


    public int getIdealRangeSize(int overallItemCount) {
        int estimatedBestExecutorCount = search.nThreads * 5;
        int rangeSize = (overallItemCount/estimatedBestExecutorCount);
        if(rangeSize<1) {
            rangeSize = 1;
        }

        return rangeSize;
    }


    protected void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    final int nextInt1 = it_s.nextInt();
                    //synchronized (result) {
					this.result.add(nextInt, nextInt1);
                    //}
                    //LOGGER.info("Output" + nextInt + "," + nextInt1);
                }
            }
        }
    }
}
