package scj.algorithm.parallel.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.result.Result;

import java.util.ArrayList;

public class RangeTaskWholeTree implements RangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeTaskWholeTree.class);

    private AdaptiveRangingSearch search;
    private int rangeStart;
    private int rangeEnd;
    private int nodeId;
    private IntList rangesS;
    private Result result;

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    // Durchsuche alle Kinder von nodeId zwischen Indizes rangeStart und i-1 und joine diese mit allen geeigneten Kindknoten von Knoten aus rangeStartS.
    public void set(AdaptiveRangingSearch onePairSearch, int nodeId, int rangeStart, int rangeEnd, IntList rangeStartsS) {
        this.search = onePairSearch;
        this.nodeId = nodeId;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.rangesS = rangeStartsS;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public void run() {

        long tmpTime = System.currentTimeMillis();
        ArrayList<Integer> freq = searchNodes(nodeId,rangeStart,rangeEnd, rangesS);

        tmpTime = System.currentTimeMillis() - tmpTime;
        search.result.add(result);
        search.informFinished(this);
        LOGGER.info("{}\t{}\t{}\t{} ms\t{}", nodeId, rangeStart, rangeEnd, tmpTime, StringUtils.join(freq));
    }

    private ArrayList<Integer> searchNodes(int nodeId, int rangeStart, int rangeEnd, IntList rangesS) {
        final IntList childrenR = search.R.getChildrenOf(nodeId);
        ArrayList<Integer> freq = new ArrayList <>();
        int freqSum = 0;
        int freqMax = 0;

     //   LOGGER.info("Call on {} up to {}, there are {} childs at all",rangeStart, rangeEnd, childrenR.size());
        for(int i=0;(i+rangeStart)<=rangeEnd;i++) {
//            LOGGER.info("Worked on {}",i+rangeStart);
            int r = childrenR.getInt(i + rangeStart);
            final int nameOf = search.R.getNameOf(r);
            // ... und joine diese mit allen geeigneten Kindknoten von Knoten aus rangeStartS.
            search(r, rangesS, nameOf);

            Integer f = 0;
            if(search.getFrequencyMap() != null && search.getFrequencyMap().containsKey(nameOf)) {
                f = search.getFrequencyMap().get(nameOf);
            } else {
                LOGGER.info("FrequencyMap is null.");
            }
            freqSum += f;
            freqMax = Math.max(freqMax,f);
        }

        freq.add(freqSum);
        freq.add(freqSum/(rangeEnd-rangeStart+1));
        freq.add(freqMax);
        return freq;

    }


    protected void search(int r, IntList s, int name) {
        IntListIterator sItr = s.iterator();
        while (sItr.hasNext()) {
            IntList result = search.S.findRanges(name, sItr.nextInt());
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                search(r, resultItr.nextInt());
            }
        }

    }
    /*
     * searchNodes.
     */
    protected void search(int r, int s) {

        lookForOutput(r, s);

        // Traversal
        for (int c_r : search.R.getChildrenOf(r)) {
            IntList result = search.S.findRanges(search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    this.result.add(nextInt, it_s.nextInt());
                }
            }
        }

    }
}
