package scj.algorithm.parallel.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;

public class InitTask implements RangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitTask.class);
    public static int RANGE_SIZE;

    @Override
    public String toString() {
        return "SplittingTask{}";
    }

    protected AdaptiveRangingSearch search;

    public InitTask(AdaptiveRangingSearch l1RangeTaskSearch) {
        this.search = l1RangeTaskSearch;
        InitTask.RANGE_SIZE = Integer.valueOf(System.getProperty("rangeSize", "5"));
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        splitAndStartSearches();
        search(0,0);
        //LOGGER.info("Run ready on {},{}", r, s);
        search.informFinished(this);
    }

    /*
     * search.
     */
    protected void search(int r, int s) {
        lookForOutput(r, s);
    }

    private void splitAndStartSearches() {
        final IntList childrenR = search.R.getChildrenOf(0);
        final int idealRangeSize = getIdealRangeSize(search.getOverallItemCount());

        int rangeStart = 0;
        int rangeFreqSum = 0;

        IntList l = new IntArrayList();
        l.add(0);

        for(int i=0;i<childrenR.size();i++) {
            int childNodeId = childrenR.getInt(i);
            final int childNodeName = search.R.getNameOf(childNodeId);
            int freq = search.getFrequencyMap().containsKey(childNodeName) ? search.getFrequencyMap().get(childNodeName) : 1;
            if(rangeFreqSum+freq < idealRangeSize) {
                rangeFreqSum+= freq;
            } else {
                if(rangeStart == i) {
                    LOGGER.info("Split node {} (name: {}), has size {} (> optimum of {})",childNodeId, childNodeName,freq, idealRangeSize);
                    // Splitte Knoten childNodeId auf, joine jeden davon mit allen Knoten rangeStartsS.
                    IntList rangeStartsS = search.S.findRanges(childNodeName, 0);
                    search.addNewSplitting(childNodeId, rangeStartsS);
                    rangeFreqSum = 0;
                    rangeStart = i+1;
                } else {
                    search.addNewSearch(0,rangeStart, i - 1, l);
                    rangeFreqSum = freq;
                    rangeStart = i;
                }
            }
        }
        if(rangeStart != childrenR.size() && childrenR.size()>0) {
            search.addNewSearch(0,rangeStart,childrenR.size()-1, l);
        }
    }


    public int getIdealRangeSize(int overallItemCount) {
        int estimatedBestExecutorCount = search.nThreads * RANGE_SIZE;
        int rangeSize = (overallItemCount/estimatedBestExecutorCount);
        if(rangeSize<1) {
            rangeSize = 1;
        }

        return rangeSize;
    }


    protected void lookForOutput(int r, int s) {
        IntCollection content_r = search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();

        if (it_r.hasNext()) {
            // Build set of results on right side
            IntCollection result_s = search.S.getIdsByPosition(s, search.S.getRangeEnd(s) + 1);

            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    final int nextInt1 = it_s.nextInt();
                    //synchronized (result) {
					search.result.add(nextInt, nextInt1);
                    //}
                    //LOGGER.info("Output" + nextInt + "," + nextInt1);
                }
            }
        }

    }

}
