package scj.algorithm.parallel.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntList;
import scj.algorithm.parallel.DAParallelAlgorithm;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorLeftSideDirect;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorRightSideDirect;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

import java.util.Map;
import java.util.Set;

public class AdaptiveRanging extends DAParallelAlgorithm {

    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());

        final Map<Integer, Integer> frequencyMap =
                rc.measure(new Executable<Map<Integer,Integer>>() {
                    public Map<Integer, Integer> execute() {
                        sortOrder.initialize(n_b);
                        return sortOrder.getFrequencyMap();
                    }
                }, "build frequency map");

        int overallItemCount = 0;
        for(Integer key: frequencyMap.keySet()) {
            overallItemCount += frequencyMap.get(key);
        }
        LOGGER.info("overall item overallItemCount: {}",overallItemCount);

        final FlatLeftTreeDirectBuild t1 =
                rc.measure(new Executable<FlatLeftTreeDirectBuild>() {
                    public FlatLeftTreeDirectBuild execute() {
                        return new FlatTreeCreatorLeftSideDirect().getInnerFlatTree(n_a, sortOrder);
                    }
                }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>() {
            public FlatLeftTree execute() {
                t1.complete();
                return t1;
            }
        }, "build prefix tree 1 -- completion");
        LOGGER.debug("Prefix tree of data set 1: {}", t1);

        PIETree t2=
                rc.measure(new Executable<PIETree>() {
                    public PIETree execute() {
                        return new FlatTreeCreatorRightSideDirect().getOuterFlatTree(n_b, sortOrder);
                    }
                }, "build prefix tree 2");
        LOGGER.debug("Prefix tree of data set 2: {}", t2);

        LOGGER.info("{}", rc);

        //Do scj on it
        if(Executor.MODE == Executor.EXECUTION_MODE.Time) {
            AdaptiveRangeSearchParallelization search = new AdaptiveRangingSearch(t1, t2, result, this.getThreads());
            search.setFrequencyMap(frequencyMap);
            search.setOverallItemCount(overallItemCount(search));
            search.search();
        }

    }

    protected int overallItemCount(AdaptiveRangeSearchParallelization search) {
        final IntList childrenR = search.R.getChildrenOf(0);
        int sum = 0;
        for(int i=0;i<childrenR.size();i++) {
            int r = childrenR.getInt(i);
            final int nameOf = search.R.getNameOf(r);

            Integer f = 0;
            if(search.getFrequencyMap() != null && search.getFrequencyMap().containsKey(nameOf)) {
                f = search.getFrequencyMap().get(nameOf);
            }
            sum += f;
        }
        return sum;
    }
}

