package scj.algorithm.parallel.adaptiveranging;

import nf.fr.eraasoft.pool.PoolSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.LoggingQueue;
import scj.algorithm.parallel.ThreadPoolExecutorWithObjectPool;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AdaptiveRangeSearchParallelization implements Search {
	private static final Logger LOGGER = LoggerFactory.getLogger(AdaptiveRangeSearchParallelization.class);

	protected int nThreads = 16;

	public Result result;
	public FlatLeftTree R;
	public PIETree S;

    protected nf.fr.eraasoft.pool.ObjectPool<? extends SearchTask> objectPool;
    private final PoolSettings<? extends SearchTask> poolSettings;
    private Map<Integer, Integer> frequencyMap;
    private int overallItemCount;

    public void setThreads(int nThreads) {
		this.nThreads = nThreads;
	}

	public ThreadPoolExecutorWithObjectPool threadPool;
	protected AtomicInteger numberOfTasks = new AtomicInteger(0);

	public AdaptiveRangeSearchParallelization(PIETree t2, Result result, FlatLeftTree t1, int nThreads) {
		this.S = t2;
		this.result = result;
		this.R = t1;

        this.setThreads(nThreads);

        this.threadPool = getThreadPoolExecutor(); // 2 Param: Queue-Typ - PriorityQueue mglich

        poolSettings = getSearchTaskPoolSettings();
        poolSettings.min(0).max(-1).validateWhenReturn(false);
        objectPool = poolSettings.pool();
        this.threadPool.setObjectPool(objectPool);

    }

    public ThreadPoolExecutorWithObjectPool getThreadPoolExecutor() {
        return new ThreadPoolExecutorWithObjectPool(nThreads, nThreads,
                0L, TimeUnit.MILLISECONDS,
                new LoggingQueue<Runnable>(nThreads));
    }

    @Override
	public Result search() {
		addNewSearchInit();

 //		LOGGER.info("working");
		while(this.numberOfTasks.get() > 0) {
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		try {
			threadPool.shutdown();
			threadPool.awaitTermination(10, TimeUnit.DAYS);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

        LOGGER.info("Final pool status: {}",threadPool.toString());
        poolSettings.shutdown();

		return this.result;
	}

    protected abstract PoolSettings<? extends SearchTask> getSearchTaskPoolSettings();

    public abstract void addNewSearchInit();

	public String toString() {
		return R + "\n" + S;
	}

    public void informFinished(SearchTask searchTaskOnePair) {
        this.numberOfTasks.decrementAndGet();
    }

    public void setFrequencyMap(Map<Integer, Integer> frequencyMap) {
        this.frequencyMap = frequencyMap;
    }

    public Map<Integer, Integer> getFrequencyMap() {
        return frequencyMap;
    }

    public void setOverallItemCount(int overallItemCount) {
        this.overallItemCount = overallItemCount;
    }

    public int getOverallItemCount() {
        return overallItemCount;
    }
}
