package scj.algorithm.parallel;


import nf.fr.eraasoft.pool.ObjectPool;
import scj.algorithm.parallel.adaptiveranging.RangeTaskWholeTree;
import scj.algorithm.parallel.listtask.SearchListTask;
import scj.algorithm.parallel.listtask.SearchListTaskOneTask;
import scj.algorithm.parallel.nodetask.SearchTask;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorWithObjectPool extends ThreadPoolExecutor {

    private ObjectPool<SearchTask> objectPool;

    public ThreadPoolExecutorWithObjectPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        try {
            if(r instanceof RangeTaskWholeTree) {
                objectPool.returnObj((SearchTask) r);
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void setObjectPool(ObjectPool<? extends SearchTask> objectPool) {
        this.objectPool = (ObjectPool<SearchTask>) objectPool;

    }
}
