package scj.algorithm.order;

import com.google.common.primitives.Ints;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import scj.input.DataTuple;
import scj.algorithm.order.comparator.FrequencyMapAscendingOrderComparator;
import scj.algorithm.order.comparator.FrequencyMapComparator;
import scj.algorithm.order.comparator.NodeNameComparator;
import scj.algorithm.tree.Node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;


public class FrequencyOrder implements SortOrder {

	private FrequencyMapComparator bvc;
    protected Map<Integer, Integer> frequencyMap;

    @Override
	public void initialize(Set<DataTuple> set) {
        frequencyMap = getFrequencyMap(set);
		bvc = getComparatorByFrequencyMap(frequencyMap);

	}

	protected FrequencyMapComparator getComparatorByFrequencyMap(Map<Integer, Integer> frequencyMap) {
		return new FrequencyMapAscendingOrderComparator(frequencyMap);
	}

	@Override
	public int[] sort(int[] set) {
		List<Integer> asList = Ints.asList(set);
		Collections.sort(asList, bvc);
		return Ints.toArray(asList);
	}
	
	/*
	public void test() {
		test(10, 100);
		test(159,158);
		test(158,159);
		test(777,779);
		test(777,778);
		test(778,779);
	}
	
	public void test(int a, int b) {
		System.out.println(a+"\t"+b+"\t= "+((FrequencyMapAscendingOrderComparator)bvc).compareDebug(a, b));
	}*/

	protected Map<Integer, Integer> getFrequencyMap(Set<DataTuple> set1) {
		Map<Integer, Integer> alphabet = new Int2IntOpenHashMap(set1.size());
		for(DataTuple r : set1) {
			for(int entry : r.getSet()) {
				if(alphabet.containsKey(entry)) {
					alphabet.put(entry, alphabet.get(entry)+1);
				} else {
					alphabet.put(entry, 1);
				}
			}
		}
		return alphabet;
	}

	@Override
	public List<Node> sort(Collection<Node> child) {
		List<Node> list = new ArrayList<>(child);
		Collections.sort(list, new NodeNameComparator(bvc));
		return list;
	}

    @Override
    public Map<Integer, Integer> getFrequencyMap() {
        return frequencyMap;
    }


    @Override
	public String toString() {
		return "FrequencyOrder";
	}
}
