package scj.algorithm.limitremade.structures;

import scj.algorithm.tree.TreeNode;

/**
 * PrefixTree used by LIMIT with the added option of limited depth,
 * compared to the PrefixTree used by PRETTI.
 * The tree cuts paths with a depth greater than the given limit and
 * adds remaining tuples to the leaf node as 'cut off tuples'.
 * @author Christopher Schiefer
 *
 */
public class LIMITAPrefixTree extends LIMITAPrefixTreeNode {
	
	private static final long serialVersionUID = 3333695468781354778L;

	public LIMITAPrefixTree(int[][] set1, int limit) {
		super(TreeNode.DEFAULT_VALUE, 0);
		this.createTree(set1, limit);		
	}
	
	private LIMITAPrefixTreeNode createTree(int[][] data, int limit) {
		LIMITAPrefixTreeNode rootNode = this;
		int contentElement;
		for(int i=1; i<data.length; i++) {
			// go to the matching position
			LIMITAPrefixTreeNode traverser = rootNode;
			traverser.increaseRecCnt();
			LIMITAPrefixTreeNode tmp;
			int depth = 0;
			for(int j=0; j<data[i].length; j++) {
				contentElement = data[i][j];
				// count how many records are passed through this node
				tmp = (LIMITAPrefixTreeNode) traverser.getChild(contentElement);
				depth++;
				if(depth <= limit) {
					// only descend the tree if limit is not reached,
					// stop otherwise;
					if(tmp != null) {
						traverser = tmp;
					} else {
						tmp = new LIMITAPrefixTreeNode(contentElement, depth);
						traverser.addChild(tmp);
						traverser = tmp;
					}
					// increase record counter for this subtree (only LIMIT PLUS)
					traverser.increaseRecCnt();
				} else {
					break;
				}
			}
			// also increase counter at node where tuple is inserted (only LIMIT PLUS)
			//traverser.increaseRecCnt();
			if(depth <= limit) {
				// insert node normally
				traverser.addContent(i);
			} else {
				// tuple does not fit into prefix tree and is added to
				// this leaf node as 'cut off' tuple
				traverser.addCutOffTuple(i);
			}
		}
		return rootNode;
		
	}
}
