package scj.algorithm.limitcomplete;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.limitremade.structures.LIMITAPrefixTree;
import scj.algorithm.limitremade.structures.LIMITAPrefixTreeNode;
import scj.algorithm.limitremade.structures.LIMITOPJInvertedIndex;
import scj.algorithm.limitremade.structures.TupleIDList;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

/**
 * Implementation of the basic LIMIT algorithm, without the
 * advanced join paradigm 'OPJ' or the LIMIT+ extension. 
 * @author Christopher Schiefer
 *
 */
public class LIMIT extends ConfigurableRawDataAlgorithm implements RawDataAlgorithm  {
	private static final Logger LOGGER = LoggerFactory.getLogger(LIMIT.class);

	SortOrder sortOrder;
	static final int SORT_ASC = 0;
	static final int SORT_DESC = 1;
	int sOrder;
	static int debug = 0;
	static int limit = 4;
	static boolean DEBUG = false;
	static boolean SHOWTREE = false;
	static long candidateCnt;
	int[][] rdArray;
	int[][] sdArray;

	public LIMIT(int limit, String so){
		// set limit
		LIMIT.limit = limit;
		// set sort order
		if(so.equals("ASC")) {
			sOrder = SORT_ASC;
			sortOrder = new InverseFrequencyOrder();
		} else if(so.equals("DESC")) {
			sOrder = SORT_DESC;
			sortOrder = new FrequencyOrder();
		}
		candidateCnt = 0;
	}

	public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
		sortOrder.initialize(set1);
		for(DataTuple r : set1) {
			r.setSet(sortOrder.sort(r.getSet()));
		}
		// set2 is also ordered for LIMIT
		sortOrder.initialize(set2);
		for(DataTuple r : set2) {
			r.setSet(sortOrder.sort(r.getSet()));
		}
		
		rdArray = new int[set1.size()+1][];
						for(DataTuple dt : set1) {
							int[] dtSet = dt.getSet();
							rdArray[dt.getId()] = dtSet;
						}
						
		sdArray = new int[set2.size()+1][];
						for(DataTuple dt : set2) {
							int[] dtSet = dt.getSet();
							sdArray[dt.getId()] = dtSet;
						}
		System.out.println("data array built");
	}
	
	@Override
	public void execute(final Set<DataTuple> set1, final Set<DataTuple> set2, Result result) {
		System.out.println("LIMIT with limit="+limit);

		RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
		
//		Map<Integer, int[]> dataMap = new Int2ObjectOpenHashMap<int[]>(set1.size());
//		for(DataTuple dt : set1) {
//			dataMap.put(dt.getId(), dt.getSet());
//		}
		
//		TupleIDList.intersectCnt = 0;
		
		final int[][] rArray = rdArray;
		final int[][] sArray = sdArray;
		
		LIMITAPrefixTree tr = 
			(LIMITAPrefixTree) rc.measure(new Executable() {
				public Object execute() {
					return new LIMITAPrefixTree(rArray, limit);
				}
			}, "build prefix tree2");
		System.out.println("prefixtree built");
		
		
		//if(DEBUG)
		//	tr.printChildren();
		//System.out.println("recs in subtree of root: "+tr.getRecsInSubtreeCnt());
		//System.out.println("tree size: "+tr.getSize());
		//System.out.println("tuples included: "+tr.getRecordCnt()+", cutoff: "+tr.getCutOffCnt());

		LIMITOPJInvertedIndex is = 
				(LIMITOPJInvertedIndex) rc.measure(new Executable() {
					public Object execute() {
						return new LIMITOPJInvertedIndex(sArray);
					}
				}, "build inv index2");
		System.out.println("inverted index built");

		//LIMIT join
		for(Node c : tr.getChildren()) {
//			if(DEBUG)
//				System.out.println("processing root child "+c.getName());
//			long st = System.currentTimeMillis();
			
			this.processNode((LIMITAPrefixTreeNode) c, is , result, limit, rArray, sArray);
//			long et = System.currentTimeMillis();
//			System.out.println("processed "+c.getName()+" in "+(et-st)+"ms, cnt="+((LIMITAPrefixTreeNode)c).getRecsInSubtreeCnt()+", avgCand="+staticCandL);

		}
//		System.out.println("Candidate count: "+candidateCnt);
//		System.out.println("Intersection count: "+TupleIDList.intersectCnt);

		LOGGER.info("{}", rc);
	}
	
	public void processNode(LIMITAPrefixTreeNode currentNode, LIMITOPJInvertedIndex invertedIndex, Result result, int limit, int[][] rArray, int[][] sArray) {
	//	if(SHOWTREE)
	//		System.out.println("node: "+fatherNode+"->"+currentNode.getName());
	//	fatherNode += "->"+currentNode.getName();
		//LOGGER.debug("Processing node {} with candidate list {}", currentNode, tupleIDCandidates);
	
		TIntArrayList tuples = invertedIndex.get(currentNode.getName());
//		int avgCandLength = 0;
//		int candLengthSum = 0;
//		TIntIterator tupitr = tuples.iterator();
//		while(tupitr.hasNext()) {
//			candLengthSum += sArray[tupitr.next()].length;
//		}
//		avgCandLength = (int)Math.ceil(candLengthSum / (double)tuples.size());
	//	System.out.println(currentNode.getName()+": avgCand="+candLengthSum+"/"+tuples.size()+"="+avgCandLength);
		
	//	if(DEBUG)
	//		System.out.println("average cand length: "+avgCandLength);
	//		int newAvgCandLength = TupleIDList.getAvgCandSize();
		

		 // This is not done by PRETTI itself, but made it 10% faster
		if(tuples.size() == 0) {
			return;
		}

		verifySmart(currentNode, tuples, limit, rArray, sArray, result);
		
		for(Node c : currentNode.getChildren()) {
			this.processNodeRecursion((LIMITAPrefixTreeNode) c, tuples , invertedIndex , result, limit, rArray, sArray);
		}
	}
		
	public void processNodeRecursion(LIMITAPrefixTreeNode currentNode, TIntArrayList tupleIDCandidates, LIMITOPJInvertedIndex invertedIndex, Result result, int limit, int[][] rArray, int[][] sArray) {
//		if(SHOWTREE)
//			System.out.print("node: "+fatherNode+"->"+currentNode.getName());
//		fatherNode += "->"+currentNode.getName();
		//LOGGER.debug("Processing node {} with candidate list {}", currentNode, tupleIDCandidates);

//		if(continueAsLIMIT(currentNode, invertedIndex, tupleIDCandidates, avgCandLength)) {
//			if(SHOWTREE)
//				System.out.println();
			// Strategy A, proceeding normally as LIMIT
			TIntArrayList tuples = TupleIDList.intersectHybrid(
				tupleIDCandidates,
				invertedIndex.get(currentNode.getName()),
				sArray
			);
//			int newAvgCandLength = TupleIDList.getAvgCandSize();
//			if(DEBUG)
//				System.out.println("new average cand length: "+newAvgCandLength);
			
			 // This is not done by PRETTI itself, but made it 10% faster
			if(tuples.size() == 0) {
				return;
			}
			
			verifySmart(currentNode, tuples, limit, rArray, sArray, result);
			
			for(Node c : currentNode.getChildren()) {
				this.processNodeRecursion((LIMITAPrefixTreeNode) c, tuples , invertedIndex , result, limit, rArray, sArray);
			}
//		} else {
////			if(SHOWTREE)
////				System.out.println("[c]");
//			// Follow strategy B, not continuing as LIMIT	
//			// depth-1 many elements are already checked by previous traversal of the tree
//			int safe = currentNode.getDepth()-1;
//			verifyNode(currentNode, tupleIDCandidates, safe, rArray, sArray, oldSIndices, result);
//			
//			for(Node child : currentNode.getChildren())
//				recCheckNode((LIMITAPrefixTreeNode)child, tupleIDCandidates, safe, rArray, sArray, oldSIndices, result);
//		}
	}
	
	public void verifySmart(LIMITAPrefixTreeNode currentNode, TIntArrayList tupleIDCandidates, int safe, int[][] rArray, int[][] sArray, Result result) {
		TIntIterator it = tupleIDCandidates.iterator();
		//System.out.println("verifyNode: "+currentNode.getName());
	
		// run through candidate list
		while(it.hasNext()) {
			int s = it.next();
			// are there tuples in this node for verification?
			if(currentNode.containsTuples()) {
				IntListIterator itr = currentNode.getTupleIds().iterator();
				while (itr.hasNext()){
					int r = itr.next();
					candidateCnt++;
					result.add(r, s);
				}
			}
			// are there cut off tuples to verify?
			if(currentNode.containsCutOffs()) {
				IntListIterator itr = currentNode.getCutOffTuples().iterator();
				int[] sSet = sArray[s];
				while (itr.hasNext()){
					int r = itr.next();
					int[] rSet = rArray[r];
					if(qualify(rSet, sSet, safe))
						result.add(r, s);
				}
			}
		}
	}
	
	public boolean qualify(int[] rSet, int[] sSet, int limit) {
		// uses sort order because either the first or last few ('limit') items
		// of each tuple are checked already
		candidateCnt++;
//		System.out.println(");
		
		if(sOrder == SORT_DESC) {
			int sCnt = limit;
			for(int rCnt = limit; rCnt < rSet.length; rCnt++) {
				int element = rSet[rCnt];
				while((sCnt < sSet.length) && (sSet[sCnt] < element))
					sCnt++;
				
				if((sCnt >= sSet.length) || (sSet[sCnt] != element)) {
					// element from r cannot be found in s
					return false;
				}
				
				sCnt++;
			}
		} else if(sOrder == SORT_ASC) {
			int sCnt = limit;
			for(int rCnt = limit; rCnt < rSet.length; rCnt++) {
				int element = rSet[rCnt];
				while((sCnt < sSet.length) && (sSet[sCnt] > element))
					sCnt++;
				
				if((sCnt >= sSet.length) || (sSet[sCnt] != element)) {
					// element from r cannot be found in s
					return false;
				}
				
				sCnt++;
			}
		}
		return true;
	}

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

}
