/* erstmal alles droppen, ob vorhanden oder nicht */
/*drop function CppPTeqFunc;
drop function CppPTltFunc;
drop function CppPTgtFunc;
drop function CppPTlikeFunc; 
drop function CppPTswFunc; 
drop function CppPTeditDFunc;
drop function CppPThammingDFunc;

drop operator CppPTeq force;
drop operator CppPTlt force;
drop operator CppPTgt force;
drop operator CppPTlike force;
drop operator CppPTsw force;
drop operator CppPTedit force;
drop operator CppPThamming force;*/

/* Funktionen definieren und integrieren */

CREATE OR REPLACE FUNCTION CppPTeqFunc(str1 IN VARCHAR2, str2 IN VARCHAR2) RETURN NUMBER AS 
begin 
  if str1 = str2 then
    return 1;
  else
    return 0;
  end if;
end;


CREATE OR REPLACE FUNCTION CppPTltFunc(str1 IN VARCHAR2, str2 IN VARCHAR2) RETURN NUMBER AS 
begin 
  if str1 < str2 then
    return 1;
  else
    return 0;
  end if;
end;

CREATE OR REPLACE FUNCTION CppPTgtFunc(str1 IN VARCHAR2, str2 IN VARCHAR2) RETURN NUMBER AS begin 
  if str1 > str2 then
    return 1;
  else
    return 0;
  end if;
end;

CREATE OR REPLACE FUNCTION CppPTlikeFunc(str1 IN VARCHAR2, str2 IN VARCHAR2) RETURN NUMBER AS begin 
  if str1 LIKE str2 then
    return 1;
  else
    return 0;
  end if;
end;


CREATE OR REPLACE FUNCTION CppPTswFunc(str1 IN VARCHAR2, prefix IN VARCHAR2) RETURN NUMBER AS begin
  if (str1 LIKE prefix || '%') then
    return 1;
  else
    return 0;
  end if;
end;

CREATE or replace function CppPTeditDFunc(str1 IN VARCHAR2, str2 IN VARCHAR2, k IN NUMBER) RETURN NUMBER AS begin
	if(utf_match.edit_ditance(str1,str2)<=k) then
	return 1;
	else return 0;
	end if;
	end;

create or replace function CppPThammingDFunc(str1 in VARCHAR2, str2 in VARCHAR2, k in NUMBER) RETURN NUMBER AS begin
	if (length(str1)!=length(str2)) then return 0;
	else 
	   len NUMBER := length(str1);
	   dist NUMBER :=0;
	   loop
	   for i in 1..len
        if(substr(str1,i,i)!=substr(str2,i,i)) then dist:=dist+1;
        else dist:=dist;
        end if;
	   end loop;
	   if(dist<k) then return 1;
	   else return 0;
	end if;
	end;

/* Operatoren definieren und jeweilige Funktion an sie binden */

CREATE OR REPLACE OPERATOR CppPTeq BINDING (VARCHAR2,VARCHAR2) RETURN NUMBER USING CppPTeqFunc;
CREATE OR REPLACE OPERATOR CppPTlt BINDING (VARCHAR2,VARCHAR2) RETURN NUMBER USING CppPTltFunc;
CREATE OR REPLACE OPERATOR CppPTgt BINDING (VARCHAR2,VARCHAR2) RETURN NUMBER USING CppPTgtFunc;
CREATE OR REPLACE OPERATOR CppPTsw BINDING (VARCHAR2,VARCHAR2) RETURN NUMBER USING CppPTswFunc;
CREATE OR REPLACE OPERATOR CppPTlike BINDING (VARCHAR2,VARCHAR2) RETURN NUMBER USING CppPTlikeFunc;
CREATE OR REPLACE OPERATOR CppPTedit BINDING (VARCHAR2,VARCHAR2,NUMBER) RETURN NUMBER USING CppPTeditDFunc;
CREATE OR REPLACE OPERATOR CppPThamming BINDING (VARCHAR2,VARCHAR2,NUMBER) RETURN NUMBER USING CppPThammingDFunc;

/* Library-Verkn�pfung erstellen */
CREATE OR REPLACE LIBRARY cppptlib as '/usr/lib/oracle/xe/app/oracle/product/10.2.0/server/bin/CppPTIndexInterface.so';

drop indextype CppPrefixInd force;
drop type body CppPTIndex;
drop type CppPTIndex force;

/* OracleType erstellen der mittels Call Specs alle Methoden des ODCII an die JavaKlasse PTIndex bindet */
CREATE OR REPLACE TYPE CppPTIndex AS OBJECT (
	scanctx RAW(4),
    STATIC FUNCTION ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList) RETURN NUMBER,
	STATIC FUNCTION ODCIIndexCreate(ia sys.ODCIIndexInfo, params varchar2, env sys.ODCIEnv) RETURN NUMBER,
	STATIC FUNCTION ODCIIndexDrop(ia sys.odciindexinfo,env SYS.ODCIEnv) RETURN NUMBER,
	STATIC FUNCTION ODCIIndexInsert(ia sys.odciindexinfo, rid VARCHAR2, newval VARCHAR2,  env sys.ODCIEnv) RETURN NUMBER,
	STATIC FUNCTION ODCIIndexDelete(ia sys.odciindexinfo, rid VARCHAR2, oldval VARCHAR2,  env sys.ODCIEnv) RETURN NUMBER, 
	STATIC FUNCTION ODCIIndexUpdate(ia sys.odciindexinfo, rid VARCHAR2, oldval VARCHAR2, newval VARCHAR2,  env sys.ODCIEnv)	RETURN NUMBER,
	STATIC FUNCTION ODCIIndexStart(
		sctx IN OUT CppPTIndex, 
		ia SYS.ODCIIndexInfo, 
		op SYS.ODCIPredInfo, 
		qi SYS.ODCIQueryInfo, 
		strt number, 
		stop number, 
		cmpval VARCHAR2, 
		env SYS.ODCIEnv) RETURN NUMBER,
	MEMBER FUNCTION ODCIIndexFetch(nrows NUMBER,rids OUT SYS.ODCIridlist,env SYS.ODCIEnv) RETURN NUMBER,
	MEMBER FUNCTION ODCIIndexClose(env SYS.ODCIEnv)	RETURN NUMBER
);

CREATE OR REPLACE TYPE BODY CppPTIndex 
IS
    STATIC FUNCTION ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
        RETURN NUMBER IS
    BEGIN
        ifclist := sys.ODCIObjectList(sys.ODCIObject('SYS','ODCIINDEX2'));
        RETURN ODCIConst.Success;
    END ODCIGetInterfaces;

    STATIC FUNCTION ODCIIndexCreate(ia sys.ODCIIndexInfo, params varchar2, env sys.ODCIEnv) RETURN NUMBER
        AS LANGUAGE C
                NAME "ODCIIndexCreate"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS (context, ia, ia indicator struct, params, params indicator, env, env indicator struct, return OCINumber );
    STATIC FUNCTION  ODCIIndexDrop(ia sys.odciindexinfo,env SYS.ODCIEnv) RETURN NUMBER
        AS LANGUAGE C
                NAME "ODCIIndexDrop"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS (context, ia, ia indicator struct, env, env indicator struct, return OCINumber );
    STATIC FUNCTION  ODCIIndexInsert(ia sys.odciindexinfo, rid VARCHAR2, newval VARCHAR2,  env sys.ODCIEnv) RETURN NUMBER 
        AS LANGUAGE C
                NAME "ODCIIndexInsert"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS (context, ia, ia indicator struct, rid, rid indicator, newVal, newVal indicator, env, env indicator struct, return OCINumber );
    STATIC FUNCTION  ODCIIndexDelete(ia sys.odciindexinfo, rid VARCHAR2, oldval VARCHAR2,  env sys.ODCIEnv) RETURN NUMBER
        AS LANGUAGE C
                NAME "ODCIIndexDelete"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS (context, ia, ia indicator struct, rid, rid indicator, oldVal, oldVal indicator, env, env indicator struct, return OCINumber );
    STATIC FUNCTION  ODCIIndexUpdate(ia sys.odciindexinfo, rid VARCHAR2, oldval VARCHAR2, newval VARCHAR2,  env sys.ODCIEnv)	RETURN NUMBER
        AS LANGUAGE C
                NAME "ODCIIndexUpdate"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS (context, ia, ia indicator struct, rid, rid indicator, oldVal, oldVal indicator, newVal, newVal indicator, env, env indicator struct, return OCINumber );

    MEMBER FUNCTION  ODCIIndexFetch(nrows NUMBER, rids OUT SYS.ODCIRidList, env SYS.ODCIEnv) RETURN NUMBER
        AS LANGUAGE C
                NAME "ODCIIndexFetch"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS ( context, self, self indicator struct, nrows, nrows indicator, rids, rids indicator, env, env indicator struct, return OCINumber );

    MEMBER FUNCTION  ODCIIndexClose(env SYS.ODCIEnv)	RETURN NUMBER
        AS LANGUAGE C
                NAME "ODCIIndexClose"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS ( context, self, self indicator struct, env, env indicator struct, return OCINumber );


    STATIC FUNCTION  ODCIIndexStart(
            sctx IN OUT CppPTIndex, 
            ia SYS.ODCIIndexInfo, 
            op SYS.ODCIPredInfo, 
            qi sys.ODCIQueryInfo, 
            strt number, 
            stop number, 
            cmpval VARCHAR2, 
            env SYS.ODCIEnv) RETURN NUMBER
        AS LANGUAGE C
                NAME "ODCIIndexStart"
                LIBRARY cppptlib
                WITH CONTEXT
                PARAMETERS (
                    context,
                    sctx, 
                    sctx indicator struct, 
                    ia, 
                    ia indicator struct, 
                    op, 
                    op indicator struct, 
                    qi, 
                    qi indicator struct, 
                    strt,
                    strt indicator, 
                    stop, 
                    stop indicator, 
                    cmpval, 
                    cmpval indicator, 
                    env, 
                    env indicator struct, 
                    return OCINumber );

END;


/* IndexTyp f�r die neuen operationen erstellen */
CREATE OR REPLACE INDEXTYPE CppPrefixInd FOR 
	CppPTeq(varchar2, varchar2),
	CppPTlt(varchar2, varchar2),
	CppPTgt(varchar2, varchar2),
	CppPTsw(varchar2, varchar2),
	CppPTlike(varchar2, varchar2),
	CppPTedit(varchar2, varchar2, number),
	CppPThamming(varchar2, varchar2, number)
USING CppPTIndex;


/* ODCII-Stats einstellungen */

/* Gute Kosten f�r den Index*/
ASSOCIATE STATISTICS WITH INDEXTYPES CppPrefixInd DEFAULT COST(1, 0, 0);

/* Schlechte Kosten f�r die Funktionen*/
ASSOCIATE STATISTICS WITH FUNCTIONS 
  CppPTeqFunc,
  CppPTltFunc,
  CppPTgtFunc,
  --CppPTbwFunc,
  CppPTlikeFunc,
  CppPTeditDFunc,
  CppPThammingDFunc
DEFAULT SELECTIVITY 1, DEFAULT COST(10, 10, 10);

