
#include "globals.hpp"


/**
 * Globale Variablen
 *
 */
bool special_debug = false;
bool global_var_use_odci = false; // wird von den itf_ODCIIndexXXXX-Funktionen und in index.cpp gesetzt


// Hilfsoperationen, die nicht zwingend in die Klasse müssen
int hashChar(char c){
		switch (c) {
		case 'A':
			return 0;
		case 'C':
			return 1;
		case 'G':
			return 2;
		case 'T':
			return 3;
		default:
			cerr << "FEHLER: Falscher Buchstabe in der Eingabemenge!!!!!!!" << endl << "char c == " << c << endl;
			exit(-1);
			return -1;
		}
}

char unhashChar(POS_TYPE pos) {
	switch (pos) {
	case 0:
		return 'A';
	case 1:
		return 'C';
	case 2:
		return 'G';
	case 3:
		return 'T';
	default:
		cerr << "FEHLER: Falscher Buchstabe in der Eingabemenge!!!!!!!" << endl << "int pos == " << pos << endl;
		exit(-1);
		return '-';
	}
}

// ermittelt die Länge des gemeinsamen Präfix'
unsigned int getPrefixLength(const char * string1, const char * string2){
	int prefix = 0;
	while(string1[prefix] && string2[prefix] && string1[prefix] == string2[prefix])
		++prefix;
	return prefix;
}

/**
 * gibt den Präfix eines LIKE-Suchmusters zurück
 */
string getPrefixFromString(string& p_string){
	//string ret;
	int zeichenAnzahl = p_string.length();
	char * str_buffer = new char[zeichenAnzahl+1];
	int i = 0;
	while(i < zeichenAnzahl && p_string[i] != '_' && p_string[i] != '%'){
			//ret += p_string[i];
			str_buffer[i] = p_string[i];
			++i;
	}
	str_buffer[i] = 0;
	string ret_string(str_buffer, i);
	delete str_buffer;
	return ret_string;
}


/**
 * Ist die Datei vorhanden?
 */
bool fileexists(string& filename){
	FILE * f = fopen(filename.c_str(),"r+b");
	if(!f){
		return false;
	}
	fclose(f);
	return true;
}

/**
 * Erstellt eine Datei (vorhandene wird überschrieben).
 */
bool filecreate(string& filename){
	FILE * f = fopen(filename.c_str(),"w");
	if(!f){
		string s("filecreate(");
		perror((s+filename+") ").c_str());
		return false;
	}
	fclose(f);
	return true;
}

/**
 * Öffnet eine Datei zum Lesen und Schreiben. Wenn nicht vorhanden, wird die Datei erstellt.
 *
 */
FILE * openOrCreateFile(string& filename, int openmode = FILEOPENMODE_READWRITE){
	if(!fileexists(filename)){
		if(!filecreate(filename)){
			return NULL;
		}
	}
	if(openmode == FILEOPENMODE_READWRITE){
		return fopen(filename.c_str(),"r+b");
	}else{
		return fopen(filename.c_str(),"rb");
	}
}

/**
 * Packt die Buchstaben des Strings (ACGT) in 2-Bit-Blöcke
 */
string packBits(const string& input){
	int laenge = input.length();
	char char_out = 0;
	// dynamisch für kompatibilität mit vc-compiler
	char * ret = new char[laenge/4 + laenge % 4 + 1];
	int k = 0;
	for(int i=0;i<laenge;){
		//char_out = 0;
		char_out = hashChar(input[i]);
		++i;
		if(i<laenge)char_out = char_out | (hashChar(input[i]) << 2);
		++i;
		if(i<laenge)char_out = char_out | (hashChar(input[i]) << 4);
		++i;
		if(i<laenge)char_out = char_out | (hashChar(input[i]) << 6);
		++i;
		ret[k++] = char_out;
	}
	ret[k]=0;
	string ret_string(ret,k);
	delete ret;
	return ret_string;
}

/**
 * Packt die Bits wieder aus; startPos nötig für das erste Byte
 */
string unpackBits(const char* input,int input_laenge, int startPos, int laenge){
	unsigned char c;//,c1,c2,c3,c4;
	//string ret;
	// dynamisch für kompatibilität mit vc-compiler
	char * ret = new char[input_laenge * 4 + 1];
	int k = 0;
	for(int i=0;i<input_laenge;++i){
		c = input[i];
		ret[k++] = unhashChar(c & (char)3);
		ret[k++] = unhashChar((c & (char)(3 << 2)) >> 2);
		ret[k++] = unhashChar((c & (char)(3 << 4)) >> 4);
		ret[k++] = unhashChar((c & (char)(3 << 6)) >> 6);
	}
	ret[startPos+laenge] = 0;
	string ret_string((char*)(ret+startPos),laenge);
	delete ret;
	return ret_string;
}

/**
 * fügt die StartPos ein
 */
void LRUList::touch(POS_TYPE startPos){
	// nach außen verlagert, um gleich den Methodenaufruf einzusparen
	//if(latest == startPos)return; // Cache für die neueste Seite
	latest = startPos;
	unsigned int newStart = 1;
	if(!lruList.empty()){
		//if(getLatest() == startPos) return; // fertig, weil schon an der richtigen Stelle
		newStart = lruList.rbegin()->first + 1;
	}
	// wenn der Zähler zu groß wird muß neu durchnumeriert werden
	// es ist zwar unwahrscheinlich, daß der Code jemals gebraucht wird, aber sicher ist sicher
	// (es müßten über 4,2 Mrd. Knoten gebaut werden)
	if(newStart == UINT_MAX -10){
		cerr << "LRUList --> new numbers" << endl;
		// hier alles neu Numerieren
		map<unsigned int, POS_TYPE> new_lruList;       // Position der Seite in der Reihenfolge
		map<POS_TYPE, unsigned int> new_lruList_index; // index-Liste --> welche Seite hat gerade welchen Wert?
		unsigned int newCounter = 0;
		for(map<unsigned int, POS_TYPE>::iterator it = lruList.begin();it != lruList.end(); ++it){
			++newCounter;
			// insert mit kleiner Hilfe
			new_lruList.insert(new_lruList.end(), pair<unsigned int, POS_TYPE>(newCounter,it->second));
			// insert mit Hilfe nicht möglich, da die Reihenfolge eine ganz andere sein kann
			new_lruList_index.insert(pair<unsigned int, POS_TYPE>(newCounter,it->second));
		}
		lruList.swap(new_lruList);
		lruList_index.swap(new_lruList_index);
	}

	// wenn newStart zu groß ist, dann alles umkrempeln
	// jetzt: wenn drin, dann löschen
	map<POS_TYPE, unsigned int>::iterator currentIndex = lruList_index.find(startPos);
	if(currentIndex != lruList_index.end()){
		// vorhanden --> aus erster Liste löschen & neu einfügen, in zweiter Liste den Wert second anpassen
		lruList.erase(currentIndex->second);
		lruList.insert(pair<unsigned int, POS_TYPE>(newStart, startPos));
		currentIndex->second = newStart;
	}else{
		lruList.insert(pair<unsigned int, POS_TYPE>(newStart, startPos));
		lruList_index.insert(pair<POS_TYPE, unsigned int>(startPos,newStart));
	}
}

/**
 * älteste Seite aus den Listen löschen
 * ... und die startPos zurückgeben
 */
POS_TYPE LRUList::pop_oldest(){
	POS_TYPE oldestPos = getOldest();
	lruList_index.erase(oldestPos);
	lruList.erase(lruList.begin());
	//cerr << "LRUList --> popped oldest : " << oldestPos << endl;
	return oldestPos;
}

bool packBitsCompression = true;
bool packBitsCompression_for_Infixes = true;

int nsIntSuffixSize = DEFAULT_INTERNALSAVEDSUFFIXSIZE_ONDISK;
int nsIntSuffixStringLength = DEFAULT_INTERNALSAVEDSUFFIXSIZE;
int nsInfixSize = DEFAULT_INTERNALSAVEDINFIXSIZE_ONDISK;
int nsInfixStringLength = DEFAULT_INTERNALSAVEDINFIXSIZE;

int nsNodeSizeOnDisk = DEFAULT_NODESIZE_ON_DISK;
int nsNodePageSize = DEFAULT_PAGESIZE_ON_DISK;
int nsSuffixPageSize = DEFAULT_SUFFIX_PAGESIZE_ON_DISK;
int nsNodePagesInBuffer = DEFAULT_NUMBER_OF_NODE_DISKPAGES_IN_MEMORY;
int nsSuffixPagesInBuffer = DEFAULT_NUMBER_OF_SUFFIX_DISKPAGES_IN_MEMORY;

int nsStuffBytesNormalNode = 0;
int nsStuffBytesSuffixNode = 0;
int nsStuffBytesInfixNode = 0;

int nsNodeBufferSize = DEFAULT_NUMBER_OF_NODE_DISKPAGES_IN_MEMORY * DEFAULT_PAGESIZE_ON_DISK;
int nsSuffixBufferSize = DEFAULT_NUMBER_OF_SUFFIX_DISKPAGES_IN_MEMORY * DEFAULT_SUFFIX_PAGESIZE_ON_DISK;

/**
 * Berechnet die Parameter
 *
 *
 */
void nsCalculateNodeSizeParameters(
		int p_intSuffixSize,
		int p_infixSize,
		int p_nodePageSize,
		int p_suffixPageSize,
		int p_nodePagesInBuffer,
		int p_suffixPagesInBuffer){

//	// jetzt die Variablen setzen, auch PageSize!
//	nsIntSuffixSize = p_intSuffixSize;
//	nsIntSuffixStringLength = p_intSuffixSize * ALPHABET_COMPRESSION_FACTOR; // Kompression
//
//	nsInfixSize = p_infixSize;
//	nsInfixStringLength = p_infixSize * ALPHABET_COMPRESSION_FACTOR;

	int alphaCompFactor_suffix = 1;
	int alphaCompFactor_infix = 1;
	if(packBitsCompression == true){alphaCompFactor_suffix = ALPHABET_COMPRESSION_FACTOR;}
	if(packBitsCompression_for_Infixes == true){alphaCompFactor_infix = ALPHABET_COMPRESSION_FACTOR;}

	nsIntSuffixStringLength = p_intSuffixSize;
	nsIntSuffixSize =
	((int)p_intSuffixSize / (int)alphaCompFactor_suffix)
	+ ((int)p_intSuffixSize % (int)alphaCompFactor_suffix > 0? 1 : 0);


	nsInfixStringLength = p_infixSize;
	nsInfixSize =
	((int)p_infixSize / (int)alphaCompFactor_infix)
	+ ((int)p_infixSize % (int)alphaCompFactor_infix > 0? 1 : 0);

	int _nsBasis =  //gesamt: 31 Bytes
		sizeof(char) + // Option-Byte 1
		sizeof(KEY_TYPE) + // der Schlüssel 8
		sizeof(SUFFIXSTART_TYPE) + // Suffix-Position 4
		sizeof(LENGTH_TYPE) + // Suffix-Länge 2
		MAXCHARS * sizeof(POS_TYPE); // LINKS 4*4 = 16

	int _nsSuffix =
		sizeof(char) + // Option-Byte 1
		sizeof(KEY_TYPE) + // der Schlüssel 8
		sizeof(SUFFIXSTART_TYPE) + // Suffix-Position 4
		sizeof(LENGTH_TYPE) + // Suffix-Länge 2
		nsIntSuffixSize; // 1-n Bytes, normal: 16

	int _nsInfix =
		sizeof(char) + // Option-Byte 1
		sizeof(LENGTH_TYPE) + // Suffix-Länge 2
		sizeof(POS_TYPE) + // Link auf nächsten Knoten 4
		nsInfixSize; // 1-n, normal 22

	// okay, daraus jetzt Maximum berechnen

	int _max1 = (_nsBasis >= _nsSuffix?_nsBasis:_nsSuffix);

	nsNodeSizeOnDisk = (_max1 > _nsInfix?_max1:_nsInfix);

	// gut, jetzt die Bytes berechnen, die noch zusätzlich "reingestopft" werden müssen
	nsStuffBytesNormalNode = nsNodeSizeOnDisk - _nsBasis;
	nsStuffBytesSuffixNode = nsNodeSizeOnDisk - _nsSuffix;
	nsStuffBytesInfixNode = nsNodeSizeOnDisk - _nsInfix;


	// jetzt die Blockgrößen berechnen
	// für die Knoten wird die Blockgröße immer aufgerundet

	int _blockNodes = p_nodePageSize / nsNodeSizeOnDisk;
	int _plus = (p_nodePageSize % nsNodeSizeOnDisk > 0 ? 1 : 0); // aufrunden!
	nsNodePageSize = (_blockNodes + _plus) * nsNodeSizeOnDisk;
	nsSuffixPageSize = (p_suffixPageSize > 4096 ? p_suffixPageSize : 4096); // mindestgröße, da ja nicht über blockränder geschrieben wird

	// Anzahl der Blöcke im Speicher zuweisen
	nsNodePagesInBuffer = p_nodePagesInBuffer;
	nsSuffixPagesInBuffer = p_suffixPagesInBuffer;

	nsNodeBufferSize = nsNodePagesInBuffer * nsNodePageSize;
	nsSuffixBufferSize = nsSuffixPagesInBuffer * nsSuffixPageSize;

}

///////Insert Astrid
	const bool submatrix[4][4]={{true,false,false,false},
								{false,true,false,false},
								{false,false,true,false},
								{false,false,false,true}};

	bool getSubstValue(int p, int t) {
		return submatrix[p][t];
	}

	///////Insert Ende
