
#ifndef _PTREE_HPP_
#define _PTREE_HPP_

#ifdef _WIN32
	#pragma warning(disable:4290)	// warning bzgl throw( XX ) ohne DLLSPEC
#endif

class PTree;

#include "globals.hpp"
#include "CharNode.hpp"
#include "Logger.hpp"

/**
 * Implementiert den Pr�fix-Baum, kontrolliert Speicher und Knoten.
 */
class PTree{
public:
	// Wurzelknoten
	CharNode * rootNode;
	//vector<string> * suffixe;

	PSpeicher * mPSpeicher;

	string name;
	string schema;
	char mode;

//#ifdef SORTED_INSERT
	// NEU, f�r sortiertes Einf�gen; erstmal nur per precompiler
	KEY_TYPE currentMaxKey;
//#endif

	PTree(string p_name, string p_schema, char p_mode);
	~PTree();

	void closefiles();

	CharNode * getRootNode(){return rootNode;}

	KEY_TYPE insertString(string& p_string, KEY_TYPE p_key);
	KEY_TYPE insertStringOrder(string& p_string)  throw (KollisionException) ; // hier mu� der Key berechnet werden
	KEY_TYPE insertStringSeq(string& p_string); // hier mu� der Key berechnet werden

	// pr�ft, ob die Keys im Baum korrekt sortiert sind...
	void checkTree();

	KEY_TYPE deleteString(string& p_string); // l�scht den String aus dem Baum

	KeyPair select_lt_gt(string& p_string); // n�chstkleinern und n�chstgr��eren suchen

	KEY_TYPE select_eq(string& p_string); // nur gleichen suchen

	KEY_TYPE select_gt(string& p_string); // n�chstgr��eren
	KEY_TYPE select_egt(string& p_string); // n�chstgr��eren oder gleichen

	KEY_TYPE select_lt(string& p_string); // n�chstkleineren
	KEY_TYPE select_elt(string& p_string); // n�chstkleineren oder gleichen


	KeyPair select_prefix(string& p_string); // Pr�fix-Suche, gibt die Range zur�ck
	KeyPairVector * select_LIKE(string& p_string); // SQL LIKE statement; mu� hier dann ohne SQL implementiert werden
	AlterKeysMap * updateAllKeys(int numberOfKeys);

	/* diesen Baum neu sortieren */
	static PTree* IOOrder(PTree* treeToOrder);

	/* gibt die InfixStatistik auf cerr aus */
	void printInfixStatistics();
	void setStringLengths(CharNode * node, unsigned int actLength);

private:
	int INITIALTABLESIZE;
		int treshold;
		int **elaTable;
		int tableWidth;
		int tableHeigth;
		char *treestr;
	// rekursive Methode f�r select_LIKE
	KeyPairVector * select_LIKE_rec(CharNode * startNode, string& p_string);
	CharNode * getPrefixSubTree(CharNode * startNode, string& prefix);
};

#ifdef _WIN32
	#pragma warning(default:4290)	// warning bzgl throw( XX ) ohne DLLSPEC
#endif

#endif

