#ifndef _LOGGER_HPP_
#define _LOGGER_HPP_

#include <iostream>
#include <string>

/*
 * Stellt Funktionen zur Ausgabe bereit, während das ODCII läuft.
 */
class Logger {

	FILE * f;
	string fileName;

public:
	/**
	 * erstellt ein Logfile mit Name, Schema und einem Zusatz
	 */
	Logger(string p_idxname, string p_idx_schema, string p_additional);

	~Logger();
	// flush FILE explicitly
	void flush();
	void close();

	friend Logger& operator<<(Logger& logger, const string& p_string);
	friend Logger& operator<<(Logger& logger, const char * p_char);
	friend Logger& operator<<(Logger& logger, const int p_int);
	friend Logger& operator<<(Logger& logger, const long p_long);
	friend Logger& operator<<(Logger& logger, const double p_double);

};

Logger& operator<<(Logger& logger, const string& p_string);
Logger& operator<<(Logger& logger, const char * p_char);
Logger& operator<<(Logger& logger, const int p_int);
Logger& operator<<(Logger& logger, const long p_long);
Logger& operator<<(Logger& logger, const double p_double);

#endif /* _LOGGER_HPP_ */
