
#include "globals.hpp"
#include "PTree.hpp"
#include "CharNode.hpp"
#include "Index.hpp"
#include "Watch.h"

#define INITIALTABLESIZE 5000
#define debug false

class KMismatch_Join {

	PTree * left;
	PTree * right;
	bool fvfilter;
	bool lengthfilter;
	Index * leftIndex;
	Index * rightIndex;
	char * leftstr;
	char * rightstr;

	int k;
public:
	KMismatch_Join(PTree *lefttree, PTree *righttree, int tresh, bool lenf, bool fv){
		//make sure, that the left tree is the smallest
		if (lefttree->mPSpeicher->getBaumSize()<righttree->mPSpeicher->getBaumSize()){
			left=lefttree;
			right=righttree;
		}
		else{
			left=righttree;
			right=lefttree;
		}
		k=tresh;
		leftstr = new char[INITIALTABLESIZE];
		rightstr = new char[INITIALTABLESIZE];
		fvfilter=fv;
		lengthfilter=lenf;
	}

	KMismatch_Join(Index *p_left_index, Index *p_right_index, int k_val,bool lenf, bool fv) :
			leftIndex(p_left_index), rightIndex(p_right_index), k(k_val) {
				if(!p_left_index || !p_right_index) exit(-1);
				//make sure, that the left tree is the smallest
				if (p_left_index->getTree()->mPSpeicher->getBaumSize()<p_right_index->getTree()->mPSpeicher->getBaumSize()){
					left=p_left_index->getTree();
					right=p_right_index->getTree();
				}
				else{
					left=p_right_index->getTree();;
					right=p_left_index->getTree();
				}
				leftstr = new char[INITIALTABLESIZE];
				rightstr = new char[INITIALTABLESIZE];
				fvfilter=fv;
				lengthfilter=lenf;

			}
	int doTestJoin(string name_left, string name_right, int k,bool lenf, bool freq);
	int join();


private:
	void joinRec2(CharNode * left,int posLeft, int posInfixLeft, CharNode * right, int posRight, int posInfixRight, int mismatches);
	void joinRec2(CharNode * left, int posInfixLeft, CharNode * right, int posInfixRight, int mismatches);
	void cmpRightSuffixNodeWithLeftTree(CharNode * left, int posLeft, int posInfixLeft, CharNode * right, int posRight, string& rsuff,int suffpos, int mismatches);
	void cmpLeftSuffixNodeWithRightTree(CharNode * right, int posRight, int posInfixRight, CharNode * left, int posLeft, string& lsuff,int suffpos, int mismatches);
	bool evalFreqVector(CharNode * left, CharNode * right, int posLeft, int posRight);
	bool evalFreqVectorForTwoSuffixes(CharNode * left, CharNode * right);
	void printMatch(int left, int right);
};

int doTestJoin(string name_left, string name_right, int k, bool lenf, bool freqf){
		Index * left = new Index(name_left,string("_"), 'W');
		Index * right = new Index(name_right,string("_"), 'W');

		KMismatch_Join j(left, right, k,lenf, freqf);

		j.join();

		delete left;
		delete right;

		return 0;
}

int KMismatch_Join::join(){
	//cerr << "initial table" <<endl;
//	printtable();
	CharNode * leftnode = left->getRootNode();
	CharNode * rightnode = right->getRootNode();
	if(lengthfilter){
		if(leftnode->minLength > rightnode->maxLength) return 0;
		if(rightnode->minLength > leftnode->maxLength) return 0;
	}
	joinRec2(left->getRootNode(),0,0,right->getRootNode(),0,0,0);
	//cerr << "done" << endl;
	return 0;
}

void KMismatch_Join::printMatch(int left, int right){
	//cout<<"Treffer mit "<<mismatches<<" Mismatches"<<endl;
	for (int i = 0; i < left;++i){
		cout<<leftstr[i];
	}
	cout<<endl;
//	for (int i = 0; i < right;++i){
//		cout<<rightstr[i];
//	}
//	cout<<"\n======================"<<endl;
}


bool KMismatch_Join::evalFreqVector(CharNode * left, CharNode * right, int posLeft, int posRight){
	int lengthdiff = abs((left->infixLength+left->suffixLength+posLeft)-(right->infixLength+right->suffixLength+posRight));
	if ((abs((int)left->freqVector[0]-(int)right->freqVector[0])-lengthdiff)>k) return false;
	if ((abs((int)left->freqVector[1]-(int)right->freqVector[1])-lengthdiff)>k) return false;
	if ((abs((int)left->freqVector[2]-(int)right->freqVector[2])-lengthdiff)>k) return false;
	if ((abs((int)left->freqVector[3]-(int)right->freqVector[3])-lengthdiff)>k) return false;
	else return true;
}


//here, lengths should be equal
bool KMismatch_Join::evalFreqVectorForTwoSuffixes(CharNode * left, CharNode * right){
	if (abs((int)left->freqVector[0]-(int)right->freqVector[0])>k) return false;
	if (abs((int)left->freqVector[1]-(int)right->freqVector[1])>k) return false;
	if (abs((int)left->freqVector[2]-(int)right->freqVector[2])>k) return false;
	if (abs((int)left->freqVector[3]-(int)right->freqVector[3])>k) return false;
	else return true;
}

/**
 * rekrusiver Teil des Joins
 */
void KMismatch_Join::joinRec2(CharNode * left,int posLeft, int posInfixLeft, CharNode * right, int posRight, int posInfixRight, int mismatches){
	//links hat infix, der noch verglichen werden muss
	if(left->hasInfix() && left->infixLength > posInfixLeft){
		//rechts hat auch infix, der noch verglichen werden muss
		if(right->hasInfix()&&right->infixLength>posInfixRight){
			if(left->getInfixRef()[posInfixLeft]==right->getInfixRef()[posInfixRight]){
				leftstr[posLeft]=left->getInfixRef()[posInfixLeft];
				rightstr[posRight]=right->getInfixRef()[posInfixRight];
				joinRec2(left, posLeft+1,posInfixLeft+1,right,posRight+1,posInfixRight+1,mismatches);
				return;
			}
			else if ((mismatches+1)<=k){
				leftstr[posLeft]=left->getInfixRef()[posInfixLeft];
				rightstr[posRight]=right->getInfixRef()[posInfixRight];
				joinRec2(left, posLeft+1,posInfixLeft+1,right,posRight+1,posInfixRight+1,mismatches+1);
				return;

			}
		}
		//rechts hat Suffix
		else if(right->hasSuffix()){
			string r(right->getIntSuffix());
			cmpRightSuffixNodeWithLeftTree(left,posLeft,posInfixLeft,right,posRight, r,0,mismatches);
			return;

		}
		//rechts hat keinen Infix oder ist an dessen Ende => untersuche Kinder
		else if(right->hasChildren()){
			for (int i = 0; i<MAXCHARS;++i){
				if(right->hasChild(i)){
					if(unhashChar(i)==left->getInfixRef()[posInfixLeft]){
						leftstr[posLeft]=left->getInfixRef()[posInfixLeft];
						rightstr[posRight]=unhashChar(i);
						CharNode * child_right = right->getChild(i);
						if(lengthfilter){
							if (left->minLength > child_right->maxLength) {
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
							if (child_right->minLength > left->maxLength){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}
						if(fvfilter){
							if(!evalFreqVector(left, child_right, posLeft-posInfixLeft-1, posRight)){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}
						joinRec2(left, posLeft+1,posInfixLeft+1,child_right,posRight+1,0,mismatches);
						right->mPSpeicher->freeCharNode(child_right);
					}
					else if((mismatches+1)<=k){
						leftstr[posLeft]=left->getInfixRef()[posInfixLeft];
						rightstr[posRight]=unhashChar(i);
						CharNode * child_right = right->getChild(i);
						if(lengthfilter){
							if (left->minLength > child_right->maxLength){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
							if (child_right->minLength > left->maxLength){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}
						if(fvfilter){
							if(!evalFreqVector(left, child_right, posLeft-posInfixLeft-1, posRight)){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}
						joinRec2(left, posLeft+1,posInfixLeft+1,child_right,posRight+1,0,mismatches+1);
						right->mPSpeicher->freeCharNode(child_right);
					}
				}
			}
			return;
		}
	}

	//rechts hat infix, der noch verglichen werden muss
	else if(right->hasInfix() && right->infixLength>posInfixRight){
		//links hat Suffix
		if(left->hasSuffix()){
			string l(left->getIntSuffix());
			cmpLeftSuffixNodeWithRightTree(right, posRight, posInfixRight, left, posLeft,l,0,mismatches);
			return;
		}
		//links hat keinen Infix oder ist an dessen Ende => untersuche Kinder
		else if(left->hasChildren()){
			//if(debug) cerr<<"\tleft->hasChildren()"<<endl;
			for (int i = 0; i<MAXCHARS;++i){
				if(left->hasChild(i)){
					if(unhashChar(i)==right->getInfixRef()[posInfixRight]){
						rightstr[posRight]=right->getInfixRef()[posInfixRight];
						leftstr[posLeft]=unhashChar(i);
						CharNode * child_left = left->getChild(i);
						if(lengthfilter){
							if (child_left->minLength > right->maxLength){
								left->mPSpeicher->freeCharNode(child_left);
								continue;
							}

							if (right->minLength > child_left->maxLength){
								left->mPSpeicher->freeCharNode(child_left);
								continue;
							}

						}
						if(fvfilter){
							if(!evalFreqVector(child_left, right, posLeft, posRight-posInfixRight-1)){
								left->mPSpeicher->freeCharNode(child_left);
								continue;
							}
						}
						joinRec2(child_left, posLeft+1,0,right,posRight+1,posInfixRight+1,mismatches);
						left->mPSpeicher->freeCharNode(child_left);
					}
					else if((mismatches+1)<=k){
						rightstr[posRight]=right->getInfixRef()[posInfixRight];
						leftstr[posLeft]=unhashChar(i);
						CharNode * child_left = left->getChild(i);
						if(lengthfilter){
							if (child_left->minLength > right->maxLength){
								left->mPSpeicher->freeCharNode(child_left);
								continue;
							}
							if (right->minLength > child_left->maxLength){
								left->mPSpeicher->freeCharNode(child_left);
								continue;
							}
						}
						if(fvfilter){
							if(!evalFreqVector(child_left, right, posLeft, posRight-posInfixRight-1)){
								left->mPSpeicher->freeCharNode(child_left);
								continue;
							}
						}
						joinRec2(child_left, posLeft+1,0,right,posRight+1,posInfixRight+1,mismatches+1);
						left->mPSpeicher->freeCharNode(child_left);
					}
				}
			}
			return;
		}
	}

	else if(left->hasSuffix()){
		string l(left->getIntSuffix());
		cmpLeftSuffixNodeWithRightTree(right, posRight, posInfixRight, left, posLeft, l,0,mismatches);
		return;

	}
	else if(right->hasSuffix()){
		string r(right->getIntSuffix());
//		if(evalFreqVector(left, right, posLeft-posInfixLeft, posRight))
		cmpRightSuffixNodeWithLeftTree(left,posLeft,posInfixLeft,right,posRight, r,0,mismatches);
		return;
	}
	else {
		if (left->hasKey()&&right->hasKey()){

			if(debug) cout<<"1left->hasKey()&&right->hasKey(). Treffer."<<endl;
			printMatch(posLeft, posRight);
		}
		for(int i=0;i<MAXCHARS;++i){
			if (left->hasChild(i)){
				CharNode * child_left = left->getChild(i);
				for (int j = 0; j < MAXCHARS;++j){
					if(right->hasChild(j)){
						CharNode * child_right = right->getChild(j);
						if(lengthfilter){
							if(child_left->minLength > child_right->maxLength){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
							if(child_right->minLength > child_left->maxLength){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}
						if(fvfilter){
							if(!evalFreqVector(child_left, child_right, posLeft, posRight)){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}
						if(i==j){
							leftstr[posLeft]=unhashChar(i);
							rightstr[posRight]=unhashChar(j);
//							if(evalFreqVector(child_left, child_right, posLeft, posRight))
							joinRec2(child_left,posLeft+1,0, child_right,posRight+1,0,mismatches);
						}
						else {
							if((mismatches+1)<=k){
								leftstr[posLeft]=unhashChar(i);
								rightstr[posRight]=unhashChar(j);
//								if(evalFreqVector(child_left, child_right, posLeft, posRight))
								joinRec2(child_left,posLeft+1,0, child_right,posRight+1,0,mismatches+1);
							}
						}
						right->mPSpeicher->freeCharNode(child_right);
					}
				}
				left->mPSpeicher->freeCharNode(child_left);
			}
		}
		return;
	}
}

void KMismatch_Join::cmpLeftSuffixNodeWithRightTree(CharNode * right, int posRight, int posInfixRight, CharNode * left, int posLeft, string& lsuff,int suffpos, int mismatches){
	int suffixLength = left->suffixLength;
	if (suffpos==nsIntSuffixStringLength) lsuff=left->getSuffix();
	//rechts hat Infix
	if(right->hasInfix() && posInfixRight<right->infixLength){
		//if(debug) cerr<<"rechts hat infix"<<endl;
		if ((right->infixLength-posInfixRight)>(suffixLength-suffpos)){
			//if(debug) cerr <<"infix ist länger als suffix.stopp."<<endl;
			return;
		}
		if(right->getInfixRef()[posInfixRight]==lsuff[suffpos]){
			leftstr[posLeft]=lsuff[suffpos];
			rightstr[posRight]=right->getInfixRef()[posInfixRight];
			//if(debug) cerr <<"cLSNWRT(_,"<< posRight+1<<", "<<posInfixRight+1<<",_, "<<posLeft+1<<",lsuff, "<<suffpos+1<<", "<<mismatches<<endl;
			cmpLeftSuffixNodeWithRightTree(right, posRight+1, posInfixRight+1, left, posLeft+1,lsuff, suffpos+1, mismatches);
			return;
		}
		else if ((mismatches+1)<=k){
			leftstr[posLeft]=lsuff[suffpos];
			rightstr[posRight]=right->getInfixRef()[posInfixRight];
			//if(debug) cerr <<"cLSNWRT(_,"<< posRight+1<<", "<<posInfixRight+1<<",_, "<<posLeft+1<<",lsuff, "<<suffpos+1<<", "<<mismatches+1<<endl;
			cmpLeftSuffixNodeWithRightTree(right, posRight+1, posInfixRight+1, left, posLeft+1,lsuff, suffpos+1, mismatches+1);
			return;
		}
		else {
			//if(debug) cerr<<"passt nicht. "<<endl;
			return;
		}
	}

	if (right->hasSuffix()){
		//if(debug) cerr<<"rechts hat suffix"<<endl;
		//restliche Suffixe sind nicht gleich lang->stop
		if (right->suffixLength!=(left->suffixLength-suffpos)){
			//if(debug) cerr << "cLSNWRT: suffixe sind unterschiedlich lang."<<endl;
			return;
		}
		if(fvfilter){
			if(!evalFreqVectorForTwoSuffixes(left,right)) return;
		}
		int rsufflen(right->suffixLength);
		int lpos(suffpos);
		int nmis(mismatches);
		int pl(posLeft);
		int pr(posRight);

		string rsuffix(right->getIntSuffix());
		//if(debug) cerr<<"vergleiche suffixe"<<endl;
		for(int i = 0; i <rsufflen;++i){
			if(i==nsIntSuffixStringLength){
				rsuffix = right->getSuffix();
			}
			if(lpos==nsIntSuffixStringLength){
				lsuff = left->getSuffix();
			}
			if(rsuffix[i]==lsuff[lpos]){
				leftstr[pl++]=lsuff[lpos++];
				rightstr[pr++]=rsuffix[i];
				//if(debug) cerr<<"kein fehler.weiter"<<endl;
				continue;
			}
			else if((nmis+1)<=k){
				leftstr[pl++]=lsuff[lpos++];
				rightstr[pr++]=rsuffix[i];
				nmis++;
				//if(debug) cerr<<"neuer fehler.weiter"<<endl;

				continue;
			}
			else{
				//if(debug) cerr<<"\tstop"<<endl;
				return;
			}
		}
		//Treffer
		if(nmis<=k){
			if(debug) cout<<"2Treffer"<<endl;
			printMatch(pl,pr);
		}
		return;
	}
	else if((right->hasKey()) && (suffpos==suffixLength)){
//		if(debug) cout<<"3Treffer"<<endl;
		//Treffer
		if(mismatches<=k){
			printMatch(posLeft,posRight);
		}
		return; //return, denn Ende v. Suffix erreicht
	}

	if (right->hasChildren()){
		//if(debug) cerr<<"rechts hat noch kinder"<<endl;
		for (int i = 0; i<MAXCHARS;++i){
			if(right->hasChild(i)){
				if(unhashChar(i)==lsuff[suffpos]){
					leftstr[posLeft]=lsuff[suffpos];
					rightstr[posRight]=unhashChar(i);
					CharNode * child_right = right->getChild(i);
					if(lengthfilter){
						if(left->minLength > child_right->maxLength){
							right->mPSpeicher->freeCharNode(child_right);
							continue;
						}
						if(left->minLength < child_right->minLength){
							right->mPSpeicher->freeCharNode(child_right);
							continue;
						}
					}
					if(fvfilter){
						if(!evalFreqVector(left, child_right, posLeft-suffpos-1, posRight)){
							right->mPSpeicher->freeCharNode(child_right);
							continue;
						}
					}
					cmpLeftSuffixNodeWithRightTree(child_right, posRight+1,0,left,posLeft+1,lsuff,suffpos+1,mismatches);
					right->mPSpeicher->freeCharNode(child_right);
				}
				else if ((mismatches+1)<=k){
					leftstr[posLeft]=lsuff[suffpos];
					rightstr[posRight]=unhashChar(i);
					CharNode * child_right = right->getChild(i);
					if(lengthfilter){
						if(left->minLength > child_right->maxLength){
							right->mPSpeicher->freeCharNode(child_right);
							continue;
						}
						if(left->minLength < child_right->minLength){
							right->mPSpeicher->freeCharNode(child_right);
							continue;
						}
					}
					if(fvfilter){
						if(!evalFreqVector(left, child_right, posLeft-suffpos-1, posRight)){
							right->mPSpeicher->freeCharNode(child_right);
							continue;
						}
					}
					cmpLeftSuffixNodeWithRightTree(child_right, posRight+1,0,left,posLeft+1,lsuff,suffpos+1,mismatches+1);
					right->mPSpeicher->freeCharNode(child_right);
				}
			}
		}
		return;
	}
}
void KMismatch_Join::cmpRightSuffixNodeWithLeftTree(CharNode * left, int posLeft, int posInfixLeft, CharNode * right, int posRight, string& rsuff,int suffpos, int mismatches){
	int suffixLength = right->suffixLength;
	if (suffpos==nsIntSuffixStringLength) rsuff=right->getSuffix();
	//links hat Infix
	if(left->hasInfix() && posInfixLeft<left->infixLength){
		//if(debug) cerr<<"links hat infix"<<endl;
		if ((left->infixLength-posInfixLeft)>(suffixLength-suffpos)){
			//if(debug) cerr <<"infix links ist länger als suffix rechts: "<< left->infixLength<<">"<<suffixLength-suffpos<<"stopp."<<endl;
			return;
		}
		if(left->getInfixRef()[posInfixLeft]==rsuff[suffpos]){
			rightstr[posRight]=rsuff[suffpos];
			leftstr[posLeft]=left->getInfixRef()[posInfixLeft];
			//if(debug) cerr <<"cLSNWRT(_,"<< posLeft+1<<", "<<posInfixLeft+1<<",_, "<<posRight+1<<",rsuff, "<<suffpos+1<<", "<<mismatches<<endl;
			cmpRightSuffixNodeWithLeftTree(left, posLeft+1, posInfixLeft+1, right, posRight+1, rsuff, suffpos+1, mismatches);
			return;
		}
		else if ((mismatches+1)<=k){
			rightstr[posRight]=rsuff[suffpos];
			leftstr[posLeft]=left->getInfixRef()[posInfixLeft];
			//if(debug) cerr <<"cLSNWRT(_,"<< posLeft+1<<", "<<posInfixLeft+1<<",_, "<<posRight+1<<",rsuff, "<<suffpos+1<<", "<<mismatches+1<<endl;
			cmpRightSuffixNodeWithLeftTree(left, posLeft+1, posInfixLeft+1, right, posRight+1,rsuff, suffpos+1, mismatches+1);
			return;
		}
		else return;
	}

	//links hat Suffix
	if (left->hasSuffix()){
		//if(debug) cerr<<"links hat suffix"<<endl;
		//restliche Suffixe sind nicht gleich lang->stop
		if (left->suffixLength!=(right->suffixLength-suffpos)){
			//if(debug) cerr << "cRSNWLT: suffixe sind unterschiedlich lang."<<endl;
			return;
		}
		if(fvfilter){
			if(!evalFreqVectorForTwoSuffixes(left,right)) return;
		}
		int lsufflen(left->suffixLength);
		int rpos(suffpos);
		int nmis(mismatches);
		int pl(posLeft);
		int pr(posRight);

		string lsuffix(left->getIntSuffix());
		for(int i = 0; i <lsufflen;++i){
			if(i==nsIntSuffixStringLength){
				lsuffix = left->getSuffix();
			}
			if(rpos==nsIntSuffixStringLength){
				rsuff = right->getSuffix();
			}
			if(lsuffix[i]==rsuff[rpos]){
				rightstr[pr++]=rsuff[rpos++];
				leftstr[pl++]=lsuffix[i];
				continue;
			}
			else if((nmis+1)<=k){
				rightstr[pr++]=rsuff[rpos++];
				leftstr[pl++]=lsuffix[i];
				nmis++;
				continue;
			}
			else return;
		}
		//Treffer
		if(nmis<=k){
			if(debug) cout<<"4Treffer.suffixe passen"<<endl;
			printMatch(pl,pr);
		}
		return;
	}
	if((left->hasKey()) && (suffpos==suffixLength) && (!left->hasSuffix())){
		if(debug) cout<<"5Treffer"<<endl;
		//Treffer
		if(mismatches<=k){
			printMatch(posLeft,posRight);
		}
		return; //return, denn Ende v. Suffix erreicht
	}


	//links hat noch Kinder
	if (left->hasChildren()){
		//if(debug) cerr<<"vergleiche kinder von links"<<endl;
		for (int i = 0; i<MAXCHARS;++i){
			if(left->hasChild(i)){
				if(unhashChar(i)==rsuff[suffpos]){
					rightstr[posRight]=rsuff[suffpos];
					leftstr[posLeft]=unhashChar(i);
					CharNode * child_left = left->getChild(i);
					if(lengthfilter){
						if(right->minLength > child_left->maxLength){
							left->mPSpeicher->freeCharNode(child_left);
							continue;
						}
						if(right->minLength < child_left->minLength){
							left->mPSpeicher->freeCharNode(child_left);
							continue;
						}
					}
					if(fvfilter){
						if(!evalFreqVector(child_left, right, posLeft, posRight-suffpos-1)){
							left->mPSpeicher->freeCharNode(child_left);
							continue;
						}
					}
					cmpRightSuffixNodeWithLeftTree(child_left, posLeft+1,0,right,posRight+1,rsuff,suffpos+1,mismatches);
					left->mPSpeicher->freeCharNode(child_left);
				}
				else if ((mismatches+1)<=k){
					rightstr[posRight]=rsuff[suffpos];
					leftstr[posLeft]=unhashChar(i);
					CharNode * child_left = left->getChild(i);
					if(lengthfilter){
						if(right->minLength > child_left->maxLength){
							left->mPSpeicher->freeCharNode(child_left);
							continue;
						}
						if(right->minLength < child_left->minLength){
							left->mPSpeicher->freeCharNode(child_left);
							continue;
						}
					}
					if(fvfilter){
						if(!evalFreqVector(child_left, right, posLeft, posRight-suffpos-1)){
							left->mPSpeicher->freeCharNode(child_left);
							continue;
						}
					}
					cmpRightSuffixNodeWithLeftTree(child_left, posLeft+1,0,right,posRight+1,rsuff,suffpos+1,mismatches+1);
					left->mPSpeicher->freeCharNode(child_left);
				}
			}
		}
		return;
	}
}




int main(int argc, char ** argv){
	// ./elajoin.out AdbEST_part1_native_stripped.dat BdbEST_part1_native_stripped.dat OJ k1
	Watch watch;
	// F - File insert
	// I - IOOrder
	// S - Statistics

	char operation = 0;
	char * fileNameA = "";
	char * fileNameB = "";
	char * destSubDir = "";
	int k = 0;
	char * note = ""; // eine Notiz, die dann an die Ausgabe weitergegeben wird
	int suffixSize = DEFAULT_INTERNALSAVEDSUFFIXSIZE; // _ONDISK;
	int infixSize = DEFAULT_INTERNALSAVEDINFIXSIZE; //b_ONDISK;
	int nodePageSize = DEFAULT_PAGESIZE_ON_DISK;
	int suffixPageSize = DEFAULT_SUFFIX_PAGESIZE_ON_DISK;
	int nodePagesInBuffer = DEFAULT_NUMBER_OF_NODE_DISKPAGES_IN_MEMORY;
	int suffixPagesInBuffer = DEFAULT_NUMBER_OF_SUFFIX_DISKPAGES_IN_MEMORY;
	bool lenfilter=false;
	bool freqfilter=false;

	for(int i=1; i < argc; ++i){

		switch(*argv[i]){

			case 'O': // Operation
				operation = argv[i][1];
				break;
			case 's': // suffix size
				suffixSize = atoi(&(argv[i][1]));
				break;
			case 'i': // infix size
				infixSize = atoi(&(argv[i][1]));
				break;

			case 'S': // suffix page size
				suffixPageSize = atoi(&(argv[i][1]));
				break;
			case 'P': // node page size
				nodePageSize = atoi(&(argv[i][1]));
				break;
			case 'l':
				lenfilter=true;
				break;
			case 'f':
				freqfilter=true;
				break;
			case 'T': // suffix pages in buffer
				suffixPagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'Q': // node pages in buffer;
				nodePagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'A': // FileName A
				fileNameA = &argv[i][1];
				break;
			case 'B': // FileName B
				fileNameB = &argv[i][1];
				break;
			case 'k':
				k = atoi(&(argv[i][1]));
				break;
			case 'D': // Destination subdir // unused
				destSubDir = &argv[i][1];
				break;
			case 'C':
				if(argv[i][1] == '+')packBitsCompression = true;
				if(argv[i][1] == '-')packBitsCompression = false;
				break;
			case 'c':
				if(argv[i][1] == '+')packBitsCompression_for_Infixes = true;
				if(argv[i][1] == '-')packBitsCompression_for_Infixes = false;
				break;
			case 'N': // Notiz
				note = &argv[i][1];
				break;
			default:
				break;
		}
	}



//	nsCalculateNodeSizeParameters(
//		suffixSize,
//		infixSize,
//		nodePageSize,
//		suffixPageSize,
//		nodePagesInBuffer,
//		suffixPagesInBuffer);
//
//	cerr << "Operation " << operation << endl;
//	cerr << "FileNameA " << fileNameA << endl;
//	cerr << "FileNameB " << fileNameB << endl;
//	cerr << "k: "<<k<<endl;
//	cerr << "DestSubDir " << destSubDir << endl;
//
//	cerr << "nsParameters" << endl;
//
//	streamout(cerr, nsInfixSize);
//	streamout(cerr, nsInfixStringLength);
//	streamout(cerr, nsIntSuffixSize);
//	streamout(cerr, nsIntSuffixStringLength);
//	cerr << endl;
//	streamout(cerr, nsNodeSizeOnDisk);
//	streamout(cerr, nsNodePageSize);
//	streamout(cerr, nsSuffixPageSize);
//	cerr << endl;
//	streamout(cerr, nsNodePagesInBuffer);
//	streamout(cerr, nsSuffixPagesInBuffer);
//	streamout(cerr, nsNodeBufferSize);
//	streamout(cerr, nsSuffixBufferSize);
//	cerr << endl;
//	streamout(cerr, nsStuffBytesNormalNode);
//	streamout(cerr, nsStuffBytesSuffixNode);
//	streamout(cerr, nsStuffBytesInfixNode);


	switch(operation){
		case 'J':{
			doTestJoin(string(fileNameA), string(fileNameB),k,lenfilter, freqfilter);
			break;}
		default:
			break;
	}



	return 0;
}
