#ifndef _JOIN_HPP_
#define _JOIN_HPP_
class Join{
	PTree * left;
	PTree * right;

	Index * leftIndex;
	Index * rightIndex;

	// ergebnisvector
	KeyPairVector kpv;
	TIDPairVector tpv;
	public:
		/**
		 * Initialisiert den Join für zwei Bäume (left, right).
		 *
		 */
		Join(PTree * p_left, PTree * p_right): left(p_left), right(p_right){}

		/**
		 * Initialisiert den Join für zwei Indizes.
		 */
		Join(Index * p_left_index, Index * p_right_index):
			leftIndex(p_left_index), rightIndex(p_right_index){
				if(!p_left_index || !p_right_index) exit(-1);
				left = p_left_index->getTree();
				right = p_right_index->getTree();}


		/**
		 * Führt den Join für Bäume aus. Gibt Referenz auf das Ergebnis zurück.
		 */
		KeyPairVector& doJoin_Trees();

		/**
		 * Führt den Join für Indizes aus. Gibt Referenz auf das Ergebnis zurück.
		 */
		TIDPairVector& doJoin();

	private:
		//void joinRec(CharNode * left, CharNode * right);
		void joinRec2(CharNode * left, int posInfixLeft, CharNode * right, int posInfixRight);
		//KEY_TYPE cmpTextTree(string p_string, CharNode * p_node);
		KEY_TYPE cmpSuffixNodeVsSubTree(CharNode * nodeWithSuffix, CharNode * nodeSubTree, bool checkFirstInfix = true, int p_infixStartAt = -1);

	};

	extern "C" {
		int itf_ODCITableStart(char * schemaName, char * leftIndexName, char * rightIndexName, char ** rowids);
	}



#endif /*_INDEX_HPP_*/
