
#include "globals.hpp"
#include "PTree.hpp"
#include "CharNode.hpp"
#include "Index.hpp"
#include "Watch.h"
#include "Join.hpp"

/**
 * Führt den Join für die TableFunction aus.
 *
 *
 */
int itf_ODCITableStart(char * schemaName, char * leftIndexName, char * rightIndexName, char ** rowids){

	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Onjekt bauen
	Index index_left(string(leftIndexName), string(schemaName),'W');
	Index index_right(string(rightIndexName), string(schemaName),'W');

	Join join(&index_left, &index_right);
	join.doJoin_Trees();

	return 0; // quasi fehler; eigentlich: leeres Ergebnis
}
/*
int itf_ODCITableStart(char * schemaName, char * leftIndexName, char * rightIndexName, char ** rowids){

	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Onjekt bauen
	Index index_left(string(leftIndexName), string(schemaName),'W');
	Index index_right(string(rightIndexName), string(schemaName),'W');

	Join join(&index_left, &index_right);
	TIDPairVector& tpv = join.doJoin(); // Ergebnis in tpv;

	if(tpv.size() > 0){
		int sizeTPV = tpv.size();
		int sizeField = (sizeTPV*CONTAINER_TID_SIZE*2)+1;// Pair: 18*2, Gesamt: Pair*Size + 1 (für die NULL)
		char * rid_field = (char*)malloc(sizeField);
		char * cPos = rid_field; // startposition

		for(TIDPairVector::iterator it = tpv.begin(); it != tpv.end(); ++it){
			memcpy(cPos, it->first.c_str(), CONTAINER_TID_SIZE);
			cPos += CONTAINER_TID_SIZE;
			memcpy(cPos, it->second.c_str(), CONTAINER_TID_SIZE);
			cPos += CONTAINER_TID_SIZE;
			//cerr << "Joined Pair < " << (*it).first << ", " << (*it).second << " >" << endl;
		}
		*cPos = 0; // sollte jetzt auf der NULL stehen, letzte Position
		// der tpv wird zusammen mit Join am Ende der Funktion vernichtet, daher keine clear-Funktion
		*rowids = rid_field;
		return sizeTPV;
	}

	return 0; // quasi fehler; eigentlich: leeres Ergebnis
}*/

/**
 * Join, auf der Basis der Indizes
 * --> holt also auch die TIDs hervor
 *
 */
TIDPairVector& Join::doJoin(){
	doJoin_Trees();
	// Ergebnis jetzt im kpv
	// jetzt noch die entsprechenden TIDs heraussuchen
	// die müssen dann quasi als sort-merge zusammengepappt werden, bzw. als Kreuzprodukt

	StringVector left_TIDs;
	StringVector right_TIDs;

	Container_simple * left_container = leftIndex->getContainer();
	Container_simple * right_container = rightIndex->getContainer();

	for(KeyPairVector::iterator it = kpv.begin(); it != kpv.end(); ++it){
		left_TIDs.clear();
		right_TIDs.clear();
		left_container->get(left_TIDs, (*it).first);
		right_container->get(right_TIDs, (*it).second);
		if(left_TIDs.size() == 1 && right_TIDs.size() == 1){
			TIDPair tp(left_TIDs.front(), right_TIDs.front());
			tpv.push_back(tp);
		}else{
			// hier Kreuzprodukt berechnen
			for(StringVector::iterator it_left = left_TIDs.begin(); it_left != left_TIDs.end(); ++it_left){
				for(StringVector::iterator it_right = right_TIDs.begin(); it_right != right_TIDs.end(); ++it_right){
					TIDPair tp(*it_left, *it_right);
					tpv.push_back(tp);
				}// for-right
			}// for-left
		}// 2x size==1
	}// for-it
	return tpv;
}

/**
 * Join auf der Basis der Bäume
 * --> nur Paare der gematchten Baum-Keys
 *
 */
KeyPairVector& Join::doJoin_Trees(){
	// Ergebnismenge leeren
	kpv.clear();
	// die rootNodes werden nicht gelöscht...!!!
	joinRec2(left->getRootNode(),0, right->getRootNode(),0);

	return kpv;
}


/**
 * rekrusiver Teil des Joins
 */
void Join::joinRec2(CharNode * left, int posInfixLeft, CharNode * right,int posInfixRight){
	//cerr << "joinRec2()" << endl;
	//cerr << "posInfixLeft  == " << posInfixLeft << ", left ==" << left << endl;
	//cerr << "posInfixRight == " << posInfixRight << ", right ==" << right << endl;

	if(left->hasInfix() && (posInfixLeft < left->infixLength) && !right->hasInfix()){
		if(right->hasSuffix()){
			// ist der letzte Vergleich auf dieser Teilstrecke
			KEY_TYPE r = cmpSuffixNodeVsSubTree(right, left, true, posInfixLeft);// aktuelles Infix wird nicht verglichen
			if(r != PTREE_NULLKEY){
				KeyPair kp(r, right->getKey());
				kpv.push_back(kp);
			}
			return;
		}else{
			if(right->hasChild(hashChar(left->getInfix()[posInfixLeft]))){
				CharNode * child_right = right->getChild(hashChar(left->getInfix()[posInfixLeft]));
				joinRec2(left,posInfixLeft+1, child_right,0);
				right->mPSpeicher->freeCharNode(child_right);
			}else{
				return;
			}
		}
	}
	if(right->hasInfix() && (posInfixRight < right->infixLength) && !left->hasInfix()){
		if(left->hasSuffix()){
			// ist der letzte Vergleich auf dieser Teilstrecke
			KEY_TYPE r = cmpSuffixNodeVsSubTree(left, right, true, posInfixRight);// aktuelles Infix wird nicht verglichen
			if(r != PTREE_NULLKEY){
				KeyPair kp(left->getKey(), r);
				kpv.push_back(kp);
			}
			return;
		}else{
			if(left->hasChild(hashChar(right->getInfix()[posInfixRight]))){
				CharNode * child_left = left->getChild(hashChar(right->getInfix()[posInfixRight]));
				joinRec2(child_left,0, right,posInfixRight+1);
				left->mPSpeicher->freeCharNode(child_left);
			}else{
				return;
			}
		}
	}

	if(left->hasInfix() && (posInfixLeft <= left->infixLength) && right->hasInfix() && (posInfixRight <= right->infixLength)){
		//cerr << "Infix und Infix" << endl;
		if((posInfixLeft < left->infixLength) && (posInfixRight < right->infixLength)){
			//cerr << "Infix und Infix (1)" << endl;
			if(left->getInfix()[posInfixLeft] == right->getInfix()[posInfixRight]){
				joinRec2(left,posInfixLeft+1, right,posInfixRight+1);
				return;
			}else{
				return;
			}
		}else{
			if((posInfixLeft == left->infixLength) && (posInfixRight < right->infixLength)){
				//cerr << "Infix und Infix (2)" << endl;
				// left eins weiterrutschen
				if(left->hasChild(hashChar(right->getInfix()[posInfixRight]))){
					CharNode * child_left = left->getChild(hashChar(right->getInfix()[posInfixRight]));
					joinRec2(child_left,0,right,posInfixRight+1);
					left->mPSpeicher->freeCharNode(child_left);
				}else{
					return;
				}
			}else
			if((posInfixLeft < left->infixLength) && (posInfixRight == right->infixLength)){
				// right eins weiterrutschen, wenns geht
				if(right->hasChild(hashChar(left->getInfix()[posInfixLeft]))){
					CharNode * child_right = right->getChild(hashChar(left->getInfix()[posInfixLeft]));
					joinRec2(left,posInfixLeft+1,child_right,0);
					right->mPSpeicher->freeCharNode(child_right);
				}else{
					return;
				}
			}
			if((posInfixLeft == left->infixLength) && (posInfixRight == right->infixLength)){
				// beide sind zuende --> beide eins weiterrutschen
				for(int k=0;k<MAXCHARS;++k){
					if(left->hasChild(k) && right->hasChild(k)){
						CharNode * child_left = left->getChild(k);
						CharNode * child_right = right->getChild(k);
						joinRec2(child_left,0, child_right,0);
						right->mPSpeicher->freeCharNode(child_right);
						left->mPSpeicher->freeCharNode(child_left);
					}
				}
				return;
			}
		}
	}

	if(!(left->hasInfix() || right->hasInfix())){
		if(left->hasSuffix() && right->hasSuffix()){
			// funktioniert auch dann, wenn Infixe dabei sind
			if(left->suffixCompareTo(right) == 0){
				KeyPair kp(left->getKey(), right->getKey());
				kpv.push_back(kp);
			}
			return; // klar daß hier nichts mehr weiter ist...
		}
		if(left->hasKey() && !left->hasSuffix() && right->hasKey() && !right->hasSuffix()){
			KeyPair kp(left->getKey(), right->getKey());
			kpv.push_back(kp);

		}else if(left->hasSuffix() && !right->hasSuffix()){
			// left hat key, right vielleicht
			KEY_TYPE r = cmpSuffixNodeVsSubTree(left, right);
			if(r != PTREE_NULLKEY){
				KeyPair kp(left->getKey(), r);
				kpv.push_back(kp);
			}
		}else if(!left->hasSuffix() && right->hasSuffix()){
			// right hat key, left vielleicht
			KEY_TYPE r = cmpSuffixNodeVsSubTree(right, left);
			if(r != PTREE_NULLKEY){
				KeyPair kp(r, right->getKey());
				kpv.push_back(kp);
			}
		}
	}// !hasInfix (2x)

	// Sonderbehandlung für Infix
	if(left->hasInfix() && right->hasSuffix()){
		// Links am Ende des Infix angekommen; Rechts an einem Suffix
		KEY_TYPE r = cmpSuffixNodeVsSubTree(right, left, false);// aktuelles Infix wird nicht verglichen
		if(r != PTREE_NULLKEY){
			KeyPair kp(r, right->getKey());
			kpv.push_back(kp);
			return;
		}
	}
	if(right->hasInfix() && left->hasSuffix()){
		// Links am Ende des Infix angekommen; Rechts an einem Suffix
		KEY_TYPE r = cmpSuffixNodeVsSubTree(left, right, false);// aktuelles Infix wird nicht verglichen
		if(r != PTREE_NULLKEY){
			KeyPair kp(left->getKey(),r);
			kpv.push_back(kp);
			return;
		}
	}

	for(int i=0;i<MAXCHARS;++i){
		if(!left->hasChild(i)) continue;
		if(right->hasChild(i)){
			CharNode * child_left = left->getChild(i);
			CharNode * child_right = right->getChild(i);
			joinRec2(child_left,0, child_right,0);
			left->mPSpeicher->freeCharNode(child_left);
			right->mPSpeicher->freeCharNode(child_right);
		}
	}
}

/**
 *  Für Suffix >< Baum-Vergleiche
 *
 *  checkFirstInfix --> gibt an, ob der Infix der nodeSubTree angeschaut werden soll oder nicht (default: true)
 *  p_infixStartAt  --> gibt ggf. die Position für den ersten Infix-Vergleich an (im nodeSubTree) (default: -1)
 *
 */
KEY_TYPE Join::cmpSuffixNodeVsSubTree(CharNode * nodeWithSuffix, CharNode * nodeSubTree, bool checkFirstInfix, int p_infixStartAt){
	CharNode * zeiger = nodeSubTree;
	unsigned int zeichenAnzahl = nodeWithSuffix->suffixLength;
	unsigned int i;
	int c;
	int infixStartAt = p_infixStartAt; //-1; // muß hier -1 sein, da kein RootKnoten vorhanden!!
	int infixFirstOffset = 0;
	if(p_infixStartAt != -1)infixFirstOffset = p_infixStartAt;

	// hier infixStartAt modifizieren, damit der Vergleich im Infix anfängt

	if(zeichenAnzahl <= (unsigned int)(nsIntSuffixStringLength)){
		// nur Vergleich mit internem Suffix
		const string& intSuffix(nodeWithSuffix->getIntSuffix());

		for(i = 0; i<zeichenAnzahl;++i){
			c = hashChar(intSuffix[i]);
			//streamout(cerr, c);

			// wenn false, wird der erste Infix nicht abgefragt
			if(checkFirstInfix){
				if(infixStartAt == -1 && zeiger->hasInfix()){
					infixStartAt = i;
				}
				if(zeiger->hasInfix() && zeiger->infixLength > (i + infixFirstOffset - infixStartAt + infixFirstOffset)){
					//cerr << "getInfix()["  << i << " + " << infixFirstOffset <<  " - " << infixStartAt << " + " << infixFirstOffset << "] == " << zeiger->getInfix()[i + infixFirstOffset - infixStartAt + infixFirstOffset] << ", intSuffix[" << i << "] == " << intSuffix[i] << endl;
					if(zeiger->getInfixRef()[i + infixFirstOffset - infixStartAt + infixFirstOffset] == intSuffix[i]){
						continue;
					}else{
						checkPosCompDelete_ext(zeiger, nodeSubTree);
						return PTREE_NULLKEY;
					}
				}else if(zeiger->hasInfix() && zeiger->infixLength == (i + infixFirstOffset - infixStartAt + infixFirstOffset)){
					// hier bin ich bei einem verketteten Infix angekommen
					infixStartAt = i+1; // i
					infixFirstOffset = 0;
				}else{
					infixStartAt = -1;
					infixFirstOffset = 0;
				}
			}
			checkFirstInfix = true;

			if(zeiger->hasChild(c)){
				CharNode * tempNode = zeiger->getChild(c);
				checkPosCompDelete_ext(zeiger, nodeSubTree);
				zeiger = tempNode;
			}else{
				if(zeiger->hasSuffix()){
					string rest = intSuffix.substr(i);
					//streamout(cerr, rest);
					if(zeiger->suffixCompareTo(rest) == 0){
						KEY_TYPE ret = zeiger->getKey();
						checkPosCompDelete_ext(zeiger, nodeSubTree);
						//streamout(cerr, ret);
						return ret;
					}
				}
				checkPosCompDelete_ext(zeiger, nodeSubTree);
				return PTREE_NULLKEY;
			}
		}// for
		KEY_TYPE ret = PTREE_NULLKEY;
		if(zeiger->hasKey() && !zeiger->hasSuffix()){
			ret = zeiger->getKey();
		}
		checkPosCompDelete_ext(zeiger, nodeSubTree);
		return ret;
	}// hier fertig mit (fast) purem internen Stringvergleich

	string suffixString(nodeWithSuffix->getIntSuffix());
	for(i = 0;i<zeichenAnzahl;++i){
		if(i == (nsIntSuffixStringLength)){
			// nur genau einmal ausführen!
			suffixString = nodeWithSuffix->getSuffix();
		}
		c = hashChar(suffixString[i]);
		//streamout(cerr, c);

		// wenn false, wird der erste Infix nicht abgefragt
		if(checkFirstInfix){
			if(infixStartAt == -1 && zeiger->hasInfix()){
				infixStartAt = i;
			}
			if(zeiger->hasInfix() && zeiger->infixLength > (i + infixFirstOffset - infixStartAt + infixFirstOffset)){
				//cerr << "getInfix()["  << i << " + " << infixFirstOffset <<  " - " << infixStartAt << " + " << infixFirstOffset << "] == " << zeiger->getInfix()[i + infixFirstOffset - infixStartAt + infixFirstOffset] << ", suffixString[" << i << "] == " << suffixString[i] << endl;
				if(zeiger->getInfixRef()[i + infixFirstOffset - infixStartAt + infixFirstOffset] == suffixString[i]){
					continue;
				}else{
					checkPosCompDelete_ext(zeiger, nodeSubTree);
					return PTREE_NULLKEY;
				}
			}else if(zeiger->hasInfix() && zeiger->infixLength == (i + infixFirstOffset - infixStartAt + infixFirstOffset)){
				// hier bin ich bei einem verketteten Infix angekommen
				infixStartAt = i+1; // i
				infixFirstOffset = 0;
			}else{
				infixStartAt = -1;
				infixFirstOffset = 0;
			}
		}
		checkFirstInfix = true;

		if(zeiger->hasChild(c)){
			CharNode * temp = zeiger->getChild(c);
			checkPosCompDelete_ext(zeiger, nodeSubTree);
			zeiger = temp;
		}else{
			if(zeiger->hasSuffix()){
				if(zeiger->suffixCompareTo_withStartPos(nodeWithSuffix, i) == 0){
					KEY_TYPE ret = zeiger->getKey(); // muß einen haben
					checkPosCompDelete_ext(zeiger, nodeSubTree);
					return ret;
				}
			}
			checkPosCompDelete_ext(zeiger, nodeSubTree);
			return PTREE_NULLKEY;
		}
	} // for
	// hier baum fertig abgestiegen --> wenn jetzt ein Key auftaucht ist es der richtige
	// ... außer wenn am Zeiger noch ein Suffix dran ist
	KEY_TYPE ret = PTREE_NULLKEY;
	if(zeiger->hasKey() && !zeiger->hasSuffix()){
		ret = zeiger->getKey();
	}
	checkPosCompDelete_ext(zeiger, nodeSubTree);
	return ret;
}

int doTestJoin(string name_left, string name_right){
	PTree * left = new PTree(name_left,string("_"), 'W');
	PTree * right = new PTree(name_right,string("_"), 'W');

	//cerr << "left:" << endl;
	//left->getRootNode()->print();
	//cerr << "right:" << endl;
	//right->getRootNode()->print();

	Join j(left, right);
	KeyPairVector& kpv = j.doJoin_Trees();

	for(KeyPairVector::iterator it = kpv.begin(); it != kpv.end(); ++it){
		cerr << "Joined Pair < " << (*it).first << ", " << (*it).second << " >" << endl;
	}

	cerr << "Node statistics...." << endl;
	// das hier verzerrt das Ergebnis!!!
	//left->getRootNode()->printStatistics(cerr);
	CharNode::printRuntimeStats(cerr);
	PSpeicher::printStatistics(cerr);


	delete left;
	delete right;

	return 0;
}


int doTestJoin_Indizes(string name_left, string name_right){
	//PTree * left = new PTree(name_left,string("_"), 'W');
	//PTree * right = new PTree(name_right,string("_"), 'W');

	Index * left = new Index(name_left,string("_"), 'W');
	Index * right = new Index(name_right,string("_"), 'W');

	cerr << "trees open" << endl;
	//cerr << "left:" << endl;
	//left->getTree()->getRootNode()->print();
	//cerr << "right:" << endl;
	//right->getTree()->getRootNode()->print();

	Join j(left, right);
	TIDPairVector& tpv = j.doJoin();

	for(TIDPairVector::iterator it = tpv.begin(); it != tpv.end(); ++it){
		cerr << "Joined Pair < " << (*it).first << ", " << (*it).second << " >" << endl;
	}

	cerr << "Node statistics...." << endl;
	// das hier verzerrt das Ergebnis!!!
	//left->getRootNode()->printStatistics(cerr);
	CharNode::printRuntimeStats(cerr);
	PSpeicher::printStatistics(cerr);


	delete left;
	delete right;

	return 0;
}

int joinBigTestRoutine(string name_left, string name_right, string note){
	Watch w;
	PTree * left = new PTree(name_left,string("_"), 'W');
	PTree * right = new PTree(name_right,string("_"), 'W');
	Join j(left, right);
	KeyPairVector& kpv = j.doJoin_Trees();
	int counter = 0;
	// = kpv.size() ginge auch, wäre aber zu schnell
	for(KeyPairVector::iterator it = kpv.begin(); it != kpv.end(); ++it){
		++counter;
	}
	cout << "Join: " << counter << " pairs found." << endl;
	cout << "XXTJOIN;"
			<< ";suffixSize;" << nsIntSuffixStringLength  // ist die Länge des Suffix-Strings! nicht die Größe im Speicher!
			<< ";infixSize;" << nsInfixStringLength
			<< ";nodePageSize;" << nsNodePageSize
			<< ";suffixPageSize;" << nsSuffixPageSize << ";"
			<< note << ";"
			<< name_left << ";"
			<< name_right << ";"
			<<  (w.stamp()/(double)1000) << ";ms;" << endl;
			/*
			<< PSpeicher::internalSuffixReadCount << "\";\"SuffixRC\";\""
			<< CharNode::internalSuffixIntCompCount << "\";\"SuffixICC\";\""
			<< CharNode::internalSuffixExtCompCount << "\";\"SuffixECC\";\""
			<< CharNode::internalNodeCountCreate << "\";\"NodeCCr\""
			<< endl;
			*/
	cout << "Node statistics...." << endl;
	// das hier verzerrt das Ergebnis!!!
	//left->getRootNode()->printStatistics(cerr);
	CharNode::printRuntimeStats(cout);
	PSpeicher::printStatistics(cout);


	delete left;
	delete right;

	return 0;
}


int main(int argc, char ** argv){
	Watch watch;
	// F - File insert
	// I - IOOrder
	// S - Statistics

	char operation = 0;
	char * fileNameA = "";
	char * fileNameB = "";
	char * destSubDir = "";
	char * note = ""; // eine Notiz, die dann an die Ausgabe weitergegeben wird
	int suffixSize = DEFAULT_INTERNALSAVEDSUFFIXSIZE; // _ONDISK;
	int infixSize = DEFAULT_INTERNALSAVEDINFIXSIZE; //b_ONDISK;
	int nodePageSize = DEFAULT_PAGESIZE_ON_DISK;
	int suffixPageSize = DEFAULT_SUFFIX_PAGESIZE_ON_DISK;
	int nodePagesInBuffer = DEFAULT_NUMBER_OF_NODE_DISKPAGES_IN_MEMORY;
	int suffixPagesInBuffer = DEFAULT_NUMBER_OF_SUFFIX_DISKPAGES_IN_MEMORY;

	for(int i=1; i < argc; ++i){

		switch(*argv[i]){

			case 'O': // Operation
				operation = argv[i][1];
				break;
			case 's': // suffix size
				suffixSize = atoi(&(argv[i][1]));
				break;
			case 'i': // infix size
				infixSize = atoi(&(argv[i][1]));
				break;

			case 'S': // suffix page size
				suffixPageSize = atoi(&(argv[i][1]));
				break;
			case 'P': // node page size
				nodePageSize = atoi(&(argv[i][1]));
				break;

			case 'T': // suffix pages in buffer
				suffixPagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'Q': // node pages in buffer;
				nodePagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'A': // FileName A
				fileNameA = &argv[i][1];
				break;
			case 'B': // FileName B
				fileNameB = &argv[i][1];
				break;
			case 'D': // Destination subdir // unused
				destSubDir = &argv[i][1];
				break;
			case 'C':
				if(argv[i][1] == '+')packBitsCompression = true;
				if(argv[i][1] == '-')packBitsCompression = false;
				break;
			case 'c':
				if(argv[i][1] == '+')packBitsCompression_for_Infixes = true;
				if(argv[i][1] == '-')packBitsCompression_for_Infixes = false;
				break;
			case 'N': // Notiz
				note = &argv[i][1];
				break;
			default:
				break;
		}
	}



	nsCalculateNodeSizeParameters(
		suffixSize,
		infixSize,
		nodePageSize,
		suffixPageSize,
		nodePagesInBuffer,
		suffixPagesInBuffer);

	cerr << "Operation " << operation << endl;
	cerr << "FileNameA " << fileNameA << endl;
	cerr << "FileNameB " << fileNameB << endl;
	cerr << "DestSubDir " << destSubDir << endl;

	cerr << "nsParameters" << endl;

	streamout(cerr, nsInfixSize);
	streamout(cerr, nsInfixStringLength);
	streamout(cerr, nsIntSuffixSize);
	streamout(cerr, nsIntSuffixStringLength);
	cerr << endl;
	streamout(cerr, nsNodeSizeOnDisk);
	streamout(cerr, nsNodePageSize);
	streamout(cerr, nsSuffixPageSize);
	cerr << endl;
	streamout(cerr, nsNodePagesInBuffer);
	streamout(cerr, nsSuffixPagesInBuffer);
	streamout(cerr, nsNodeBufferSize);
	streamout(cerr, nsSuffixBufferSize);
	cerr << endl;
	streamout(cerr, nsStuffBytesNormalNode);
	streamout(cerr, nsStuffBytesSuffixNode);
	streamout(cerr, nsStuffBytesInfixNode);


	switch(operation){
		case 'J':{
			doTestJoin_Indizes(string(fileNameA), string(fileNameB));
			break;}
		case 'T':{
			joinBigTestRoutine(string(fileNameA), string(fileNameB), string(note));
			break;}
		default:
			break;
	}



	return 0;
}

//int main(int argc, char **argv){
//
//	time_t startTime = time(NULL);
//	clock_t startClock = clock();
//
//	if(4 == argc){
//		// 1 --> Progname
//		// 2 --> Option => J
//		// 3 --> name_left
//		// 4 --> name_right (alle im data-Verzeichnis)
//
//		if(*argv[1] == 'J'){
//			Watch w;
//			doTestJoin_Indizes(string(argv[2]), string(argv[3]));
//			//doTestJoin(string(argv[2]), string(argv[3]));
//		}
//	}
//
//	time_t endTime = time(NULL);
//	clock_t endClock = clock();
//
//	cout << "Ausführungszeit: (time) " << (endTime - startTime) << " Sekunden" << endl;
//	cout << "Ausführungszeit: (clock)" << (double)(endClock - startClock)/(double)CLOCKS_PER_SEC << " Sekunden" << endl;
//
//	return 0;
//}
//
